/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.analyzer.MetricTagAggregator;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.ApplicationEnvironment;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.MessageTreeTypeParser;
import cn.com.duiba.cat.model.configuration.MessageType;
import cn.com.duiba.cat.model.configuration.NetworkInterfaceManager;
import cn.com.duiba.cat.model.configuration.ProblemLongType;
import cn.com.duiba.cat.model.configuration.client.entity.ClientConfig;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.model.configuration.client.transform.DefaultSaxParser;
import cn.com.duiba.cat.model.configuration.property.entity.Property;
import cn.com.duiba.cat.model.configuration.property.entity.PropertyConfig;
import cn.com.duiba.cat.util.NetworkHelper;
import cn.com.duiba.cat.util.Properties;
import cn.com.duiba.cat.util.Splitters;
import cn.com.duiba.cat.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientConfigService
implements ClientConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientConfigService.class);
    private static DefaultClientConfigService instance = new DefaultClientConfigService();
    private ClientConfig config;
    private String routers;
    private volatile double samplingRate = 1.0;
    private volatile boolean block = false;
    private volatile int timeout = 1000;
    private MessageTreeTypeParser treeParser = new MessageTreeTypeParser();
    private Map<String, List<Integer>> longConfigs = new LinkedHashMap<String, List<Integer>>();

    private DefaultClientConfigService() {
        String config = System.getProperty("cat-client-config");
        if (StringUtils.isNotEmpty(config)) {
            try {
                this.config = DefaultSaxParser.parse(config);
                LOGGER.info("setup cat with config:" + config);
            }
            catch (Exception e) {
                LOGGER.error("error in client config " + config, (Throwable)e);
            }
        }
        if (this.config == null) {
            String appName = ApplicationEnvironment.loadAppName("unknown");
            ClientConfig defaultConfig = ApplicationEnvironment.loadClientConfig(appName);
            defaultConfig.setDomain(appName);
            this.config = defaultConfig;
            LOGGER.info("setup cat with default configuration:" + this.config);
        }
    }

    public static DefaultClientConfigService getInstance() {
        return instance;
    }

    @Override
    public int getClientConnectTimeout() {
        return this.timeout;
    }

    @Override
    public String getDomain() {
        return this.config.getDomain();
    }

    @Override
    public int getLongConfigThreshold(String key) {
        List<Integer> values = this.longConfigs.get(key);
        int value = values != null && !values.isEmpty() ? values.get(0).intValue() : ProblemLongType.findByName(key).getThreshold();
        return value;
    }

    @Override
    public int getLongThresholdByDuration(String key, int duration) {
        List<Integer> values = this.longConfigs.get(key);
        if (values != null) {
            for (int i = values.size() - 1; i >= 0; --i) {
                int userThreshold = values.get(i);
                if (duration < userThreshold) continue;
                return userThreshold;
            }
        }
        return -1;
    }

    @Override
    public String getRouters() {
        if (this.routers == null) {
            this.refreshConfig();
        }
        return this.routers;
    }

    @Override
    public double getSamplingRate() {
        return this.samplingRate;
    }

    private String getServerConfigUrl(ClientConfig config, int index) {
        List<Server> servers = config.getServers();
        int size = servers.size();
        Server server = servers.get(index % size);
        int httpPort = server.getHttpPort();
        String serverIp = server.getIp();
        String hostname = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        try {
            hostname = URLEncoder.encode(hostname, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return String.format("http://%s:%d/cat/s/router?domain=%s&ip=%s&op=xml&env=%s&hostname=%s", serverIp.trim(), httpPort, this.getDomain(), ip, ApplicationEnvironment.ENVIRONMENT, hostname);
    }

    @Override
    public List<Server> getServers() {
        return this.config.getServers();
    }

    private boolean isDevMode() {
        String devMode = Properties.forString().fromEnv().fromSystem().getProperty("devMode", "false");
        return "true".equals(devMode);
    }

    @Override
    public boolean isMessageBlock() {
        return this.block;
    }

    @Override
    public MessageType parseMessageType(MessageTree tree) {
        if (!tree.canDiscard()) {
            return MessageType.NORMAL_MESSAGE;
        }
        return this.treeParser.parseMessageType(tree);
    }

    @Override
    public void refreshConfig() {
        int start = (int)(Math.random() * 10.0);
        int maxRetryCount = 3;
        boolean refreshStatus = false;
        for (int retry = 0; retry < maxRetryCount; ++retry) {
            String url = this.getServerConfigUrl(this.config, start + retry);
            try {
                this.refreshConfig(url);
                refreshStatus = true;
                break;
            }
            catch (Exception e) {
                LOGGER.error("error when connect cat server config url " + url);
                continue;
            }
        }
        if (!refreshStatus && !this.isDevMode()) {
            try {
                String xml = ApplicationEnvironment.loadRemoteClientConfig();
                ClientConfig config = DefaultSaxParser.parse(xml);
                config.setDomain(this.getDomain());
                String url = this.getServerConfigUrl(config, start);
                this.refreshConfig(url);
            }
            catch (Exception e) {
                LOGGER.error("error when connect cat server config url from remote config");
            }
        }
    }

    @Override
    public void refreshConfig(PropertyConfig routerConfig) {
        this.refreshRouters(routerConfig);
        this.refreshInnerConfig(routerConfig);
    }

    private void refreshConfig(String url) throws Exception {
        String content = NetworkHelper.readFromUrlWithRetry(url);
        PropertyConfig routerConfig = cn.com.duiba.cat.model.configuration.property.transform.DefaultSaxParser.parse(content.trim());
        if (this.refreshRouters(routerConfig)) {
            this.storeServersByUrl(url);
            this.refreshInnerConfig(routerConfig);
        }
    }

    private void refreshInnerConfig(PropertyConfig routerConfig) {
        Property timeout;
        int maxMetricTagValues;
        this.samplingRate = Double.parseDouble(routerConfig.findProperty("sample").getValue());
        if (this.samplingRate <= 0.0) {
            this.samplingRate = 0.0;
        }
        this.block = Boolean.parseBoolean(routerConfig.findProperty("block").getValue());
        if (this.block) {
            Cat.disable();
        } else {
            Cat.enable();
        }
        String multiInstancesConfig = routerConfig.findProperty("multiInstances").getValue();
        if (StringUtils.isNotEmpty(multiInstancesConfig)) {
            boolean multiInstances = Boolean.parseBoolean(multiInstancesConfig);
            if (multiInstances) {
                Cat.enableMultiInstances();
            } else {
                Cat.disableMultiInstances();
            }
        }
        String startTypes = routerConfig.findProperty("startTransactionTypes").getValue();
        String matchTypes = routerConfig.findProperty("matchTransactionTypes").getValue();
        for (ProblemLongType longType : ProblemLongType.values()) {
            String values;
            String name = longType.getName();
            String propertyName = name + "s";
            Property property = routerConfig.findProperty(propertyName);
            if (property == null || (values = property.getValue()) == null) continue;
            List<String> valueStrs = Splitters.by(',').trim().split(values);
            LinkedList<Integer> thresholds = new LinkedList<Integer>();
            for (String valueStr : valueStrs) {
                try {
                    thresholds.add(Integer.parseInt(valueStr));
                }
                catch (Exception exception) {}
            }
            if (thresholds.isEmpty()) continue;
            this.longConfigs.put(name, thresholds);
        }
        this.treeParser.refresh(startTypes, matchTypes);
        Property maxMetricProperty = routerConfig.findProperty("maxMetricTagValues");
        if (maxMetricProperty != null && (maxMetricTagValues = Integer.parseInt(maxMetricProperty.getValue())) != MetricTagAggregator.MAX_KEY_SIZE) {
            MetricTagAggregator.MAX_KEY_SIZE = maxMetricTagValues;
        }
        if ((timeout = routerConfig.findProperty("clientConnectTimeout")) != null) {
            this.timeout = Integer.parseInt(timeout.getValue());
        }
    }

    private boolean refreshRouters(PropertyConfig routerConfig) {
        String newRouters = routerConfig.findProperty("routers").getValue();
        if (this.routers == null || !this.routers.equals(newRouters)) {
            this.routers = newRouters;
            return true;
        }
        return false;
    }

    public void setSample(double sample) {
        this.samplingRate = sample;
    }

    private void storeServersByUrl(String url) {
        try {
            URL u = new URL(url);
            int httpPort = u.getPort();
            ApplicationEnvironment.storeServers(this.routers, httpPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

