/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Domain
extends BaseEntity<Domain> {
    private String id;
    private String ip;
    private boolean enabled = true;
    private int maxMessageSize = 1000;

    public Domain() {
    }

    public Domain(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDomain(this);
    }

    @Override
    public void mergeAttributes(Domain other) {
        this.assertAttributeEquals(other, "domain", "id", this.id, other.getId());
        if (other.getIp() != null) {
            this.ip = other.getIp();
        }
        this.enabled = other.isEnabled();
        this.maxMessageSize = other.getMaxMessageSize();
    }

    public String getId() {
        return this.id;
    }

    public Domain setId(String id) {
        this.id = id;
        return this;
    }

    public String getIp() {
        return this.ip;
    }

    public Domain setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Domain setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Domain setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain = (Domain)o;
        return new EqualsBuilder().append(this.enabled, domain.enabled).append(this.maxMessageSize, domain.maxMessageSize).append((Object)this.id, (Object)domain.id).append((Object)this.ip, (Object)domain.ip).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.ip).append(this.enabled).append(this.maxMessageSize).toHashCode();
    }
}

