/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Server
extends BaseEntity<Server> {
    private String ip;
    private int port = 2280;
    private int httpPort = 8080;
    private boolean enabled = true;

    public Server() {
    }

    public Server(String ip) {
        this.ip = ip;
    }

    public Server(String ip, int httpPort) {
        this.ip = ip;
        this.httpPort = httpPort;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitServer(this);
    }

    @Override
    public void mergeAttributes(Server other) {
        this.assertAttributeEquals(other, "server", "ip", this.ip, other.getIp());
        this.port = other.getPort();
        this.httpPort = other.getHttpPort();
        this.enabled = other.isEnabled();
    }

    public String getIp() {
        return this.ip;
    }

    public Server setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Server setPort(int port) {
        this.port = port;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public Server setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        return new EqualsBuilder().append(this.port, server.port).append(this.httpPort, server.httpPort).append(this.enabled, server.enabled).append((Object)this.ip, (Object)server.ip).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.ip).append(this.port).append(this.httpPort).append(this.enabled).toHashCode();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Server setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

