/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration.client.transform;

import cn.com.duiba.cat.model.configuration.client.entity.Bind;
import cn.com.duiba.cat.model.configuration.client.entity.ClientConfig;
import cn.com.duiba.cat.model.configuration.client.entity.Domain;
import cn.com.duiba.cat.model.configuration.client.entity.Property;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.model.configuration.client.transform.ILinker;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinker
implements ILinker {
    private boolean deferrable;
    private List<Runnable> deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.deferedJobs) {
            job.run();
        }
    }

    @Override
    public boolean onBind(ClientConfig parent, Bind bind) {
        parent.setBind(bind);
        return true;
    }

    @Override
    public boolean onDomain(final ClientConfig parent, final Domain domain) {
        if (this.deferrable) {
            this.deferedJobs.add(new Runnable(){

                @Override
                public void run() {
                    parent.addDomain(domain);
                }
            });
        } else {
            parent.addDomain(domain);
        }
        return true;
    }

    @Override
    public boolean onProperty(ClientConfig parent, Property property) {
        parent.addProperty(property);
        return true;
    }

    @Override
    public boolean onServer(ClientConfig parent, Server server) {
        parent.addServer(server);
        return true;
    }
}

