/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.jvm;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ThreadInfoWriter {
    private static final int MAX_FRAMES = 200;
    private static final String PROTOCOL_ID = "ThreadDumpCat";
    private Map<String, Integer> wordTable = new HashMap<String, Integer>();
    private short offset = 0;

    public String buildThreadsInfo(ThreadInfo[] threads) {
        StringBuilder result = new StringBuilder();
        StringBuilder codeResult = new StringBuilder();
        result.append(PROTOCOL_ID);
        result.append("1");
        for (ThreadInfo thread : threads) {
            int threadSize = this.processThread(thread, codeResult);
            codeResult.insert(codeResult.length() - threadSize, String.format("%04d", threadSize));
        }
        this.appendWordTable(result);
        result.append(String.format("%08d", threads.length));
        result.append((CharSequence)codeResult);
        return result.toString();
    }

    private int processThread(ThreadInfo thread, StringBuilder codeResult) {
        StackTraceElement[] stackTrace;
        int lastSize = codeResult.length();
        codeResult.append(String.format("%08d", thread.getThreadId()));
        String stateCode = this.getStateCode(thread.getThreadState());
        codeResult.append(stateCode);
        String name = thread.getThreadName();
        this.addToWordTable(name);
        String code = this.encode(name);
        codeResult.append(code);
        codeResult.append(this.buildExternalFlag(thread));
        name = thread.getLockName();
        if (name != null) {
            this.addToWordTable(name);
            code = this.encode(name);
            codeResult.append(code);
        }
        if ((name = thread.getLockOwnerName()) != null) {
            this.addToWordTable(name);
            code = this.encode(name);
            codeResult.append(code);
            String ownerId = String.valueOf(thread.getLockOwnerId());
            codeResult.append(ownerId).append("#");
        }
        byte stackSize = (byte)((stackTrace = thread.getStackTrace()).length < 200 ? stackTrace.length : 200);
        codeResult.append(String.format("%04d", stackSize));
        for (int i = 0; i < stackTrace.length && i < 200; ++i) {
            StackTraceElement stack = stackTrace[i];
            this.processStack(stack, codeResult);
        }
        return codeResult.length() - lastSize;
    }

    private void processStack(StackTraceElement stack, StringBuilder codeResult) {
        String name = String.format("%s.%s", stack.getClassName(), stack.getMethodName());
        this.addToWordTable(name);
        String code = this.encode(name);
        codeResult.append(code);
        if (stack.getFileName() != null) {
            this.addToWordTable(stack.getFileName());
            code = this.encode(stack.getFileName());
            codeResult.append(code);
            int lineNumber = stack.getLineNumber();
            codeResult.append(String.format("%05d", lineNumber));
        } else {
            codeResult.append("0#");
            codeResult.append(String.format("%05d", 0));
        }
    }

    private void appendWordTable(StringBuilder result) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.wordTable.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        result.append("[");
        for (Map.Entry entry : list) {
            result.append((String)entry.getKey()).append(",");
        }
        if (list.size() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        result.append("]");
    }

    private String buildExternalFlag(ThreadInfo thread) {
        String result;
        byte externalFlag = 0;
        if (thread.isInNative()) {
            externalFlag = (byte)(externalFlag | 1);
        }
        if (thread.isSuspended()) {
            externalFlag = (byte)(externalFlag | 2);
        }
        if (thread.getLockName() != null) {
            externalFlag = (byte)(externalFlag | 4);
        }
        if (thread.getLockOwnerName() != null) {
            externalFlag = (byte)(externalFlag | 8);
        }
        switch (externalFlag) {
            case 10: {
                result = "A";
                break;
            }
            case 11: {
                result = "B";
                break;
            }
            case 12: {
                result = "C";
                break;
            }
            case 13: {
                result = "D";
                break;
            }
            case 14: {
                result = "E";
                break;
            }
            case 15: {
                result = "F";
                break;
            }
            default: {
                result = String.valueOf(externalFlag);
            }
        }
        return result;
    }

    private String encode(String str) {
        int offset = this.wordTable.get(str);
        StringBuilder result = new StringBuilder(String.valueOf(offset));
        return result.append("#").toString();
    }

    private String getStateCode(Thread.State state) {
        switch (state) {
            case NEW: {
                return "0";
            }
            case RUNNABLE: {
                return "1";
            }
            case BLOCKED: {
                return "2";
            }
            case WAITING: {
                return "3";
            }
            case TIMED_WAITING: {
                return "4";
            }
            case TERMINATED: {
                return "5";
            }
        }
        return "6";
    }

    private void addToWordTable(String word) {
        if (!this.wordTable.containsKey(word)) {
            short code = this.offset;
            this.wordTable.put(word, Integer.valueOf(code));
            this.offset = (short)(this.offset + 1);
        }
    }
}

