/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;
import cn.com.duiba.cat.status.model.entity.ExtensionDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class Extension
extends BaseEntity<Extension> {
    private final Map<String, ExtensionDetail> details = new LinkedHashMap<String, ExtensionDetail>();
    private String id;
    private String description;
    private Map<String, String> dynamicAttributes = new LinkedHashMap<String, String>();

    public Extension() {
    }

    public Extension(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitExtension(this);
    }

    public Extension addExtensionDetail(ExtensionDetail extensionDetail) {
        this.details.put(extensionDetail.getId(), extensionDetail);
        return this;
    }

    public ExtensionDetail findExtensionDetail(String id) {
        return this.details.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionDetail findOrCreateExtensionDetail(String id) {
        ExtensionDetail extensionDetail = this.details.get(id);
        if (extensionDetail == null) {
            Map<String, ExtensionDetail> map = this.details;
            synchronized (map) {
                extensionDetail = this.details.get(id);
                if (extensionDetail == null) {
                    extensionDetail = new ExtensionDetail(id);
                    this.details.put(id, extensionDetail);
                }
            }
        }
        return extensionDetail;
    }

    @Override
    public void mergeAttributes(Extension other) {
        this.assertAttributeEquals(other, "extension", "id", this.id, other.getId());
        for (Map.Entry<String, String> e : other.getDynamicAttributes().entrySet()) {
            this.dynamicAttributes.put(e.getKey(), e.getValue());
        }
    }

    public boolean removeExtensionDetail(String id) {
        if (this.details.containsKey(id)) {
            this.details.remove(id);
            return true;
        }
        return false;
    }

    public void setDynamicAttribute(String name, String value) {
        this.dynamicAttributes.put(name, value);
    }

    public String getId() {
        return this.id;
    }

    public Extension setId(String id) {
        this.id = id;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Extension setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, ExtensionDetail> getDetails() {
        return this.details;
    }

    public Map<String, String> getDynamicAttributes() {
        return this.dynamicAttributes;
    }

    public void setDynamicAttributes(Map<String, String> dynamicAttributes) {
        this.dynamicAttributes = dynamicAttributes;
    }
}

