package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.message.Trace;
import cn.com.duiba.cat.message.spi.MessageManager;

public class DefaultTrace extends AbstractMessage implements Trace {

    private MessageManager manager;

    public DefaultTrace(String type, String name) {
        super(type, name);
    }

    public DefaultTrace(String type, String name, MessageManager manager) {
        super(type, name);

        this.manager = manager;
    }

    @Override
    public void complete() {
        setCompleted(true);

        if (manager != null) {
            manager.add(this);
        }
    }
}
