package cn.com.duiba.cat.model.configuration.property.entity;

import cn.com.duiba.cat.model.configuration.property.BaseEntity;
import cn.com.duiba.cat.model.configuration.property.Constants;
import cn.com.duiba.cat.model.configuration.property.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Property extends BaseEntity<Property> {

    private String id;
    private String value;

    public Property() {
    }

    public Property(String id) {
        this.id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitProperty(this);
    }

    @Override
    public void mergeAttributes(Property other) {
        assertAttributeEquals(other, Constants.ENTITY_PROPERTY, Constants.ATTR_ID, id, other.getId());

        if (other.getValue() != null) {
            value = other.getValue();
        }
    }

    public String getId() {
        return id;
    }

    public Property setId(String id) {
        this.id = id;
        return this;
    }

    public String getValue() {
        return value;
    }

    public Property setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Property property = (Property) o;

        return new EqualsBuilder().append(id, property.id).append(value, property.value).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(id).append(value).toHashCode();
    }
}
