package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;

public class ThreadsInfo extends BaseEntity<ThreadsInfo> {

    private int    count;
    private int    daemonCount;
    private int    peekCount;
    private int    totalStartedCount;
    private int    catThreadCount;
    private int    pigeonThreadCount;
    private int    httpThreadCount;
    private String dump;

    public ThreadsInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitThread(this);
    }

    @Override
    public void mergeAttributes(ThreadsInfo other) {
        count = other.getCount();

        daemonCount = other.getDaemonCount();

        peekCount = other.getPeekCount();

        totalStartedCount = other.getTotalStartedCount();

        catThreadCount = other.getCatThreadCount();

        pigeonThreadCount = other.getPigeonThreadCount();

        httpThreadCount = other.getHttpThreadCount();
    }

    public int getCount() {
        return count;
    }

    public ThreadsInfo setCount(int count) {
        this.count = count;
        return this;
    }

    public int getDaemonCount() {
        return daemonCount;
    }

    public ThreadsInfo setDaemonCount(int daemonCount) {
        this.daemonCount = daemonCount;
        return this;
    }

    public int getPeekCount() {
        return peekCount;
    }

    public ThreadsInfo setPeekCount(int peekCount) {
        this.peekCount = peekCount;
        return this;
    }

    public int getTotalStartedCount() {
        return totalStartedCount;
    }

    public ThreadsInfo setTotalStartedCount(int totalStartedCount) {
        this.totalStartedCount = totalStartedCount;
        return this;
    }

    public int getCatThreadCount() {
        return catThreadCount;
    }

    public ThreadsInfo setCatThreadCount(int catThreadCount) {
        this.catThreadCount = catThreadCount;
        return this;
    }

    public int getPigeonThreadCount() {
        return pigeonThreadCount;
    }

    public ThreadsInfo setPigeonThreadCount(int pigeonThreadCount) {
        this.pigeonThreadCount = pigeonThreadCount;
        return this;
    }

    public int getHttpThreadCount() {
        return httpThreadCount;
    }

    public ThreadsInfo setHttpThreadCount(int httpThreadCount) {
        this.httpThreadCount = httpThreadCount;
        return this;
    }

    public String getDump() {
        return dump;
    }

    public ThreadsInfo setDump(String dump) {
        this.dump = dump;
        return this;
    }
}
