/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.analyzer;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.analyzer.EventAggregator;
import cn.com.duiba.cat.analyzer.MetricTagAggregator;
import cn.com.duiba.cat.analyzer.TransactionAggregator;
import cn.com.duiba.cat.message.Event;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.util.Threads;
import java.util.List;

public class LocalAggregator {
    public static void aggregate(MessageTree tree) {
        LocalAggregator.analyzerProcessTree(tree);
    }

    private static void analyzerProcessTransaction(Transaction transaction) {
        TransactionAggregator.getInstance().logTransaction(transaction);
        List<Message> child = transaction.getChildren();
        for (Message message : child) {
            if (message instanceof Transaction) {
                LocalAggregator.analyzerProcessTransaction((Transaction)message);
                continue;
            }
            if (!(message instanceof Event)) continue;
            EventAggregator.getInstance().logEvent((Event)message);
        }
    }

    private static void analyzerProcessTree(MessageTree tree) {
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            LocalAggregator.analyzerProcessTransaction((Transaction)message);
        } else if (message instanceof Event) {
            EventAggregator.getInstance().logEvent((Event)message);
        }
    }

    public static class DataUploader
    implements Threads.Task {
        private boolean active = true;

        @Override
        public String getName() {
            return "local-data-aggregator";
        }

        @Override
        public void run() {
            while (this.active) {
                long duration;
                long start = System.currentTimeMillis();
                try {
                    TransactionAggregator.getInstance().sendTransactionData();
                    EventAggregator.getInstance().sendEventData();
                    MetricTagAggregator.getInstance().sendMetricTagData();
                }
                catch (Exception ex) {
                    Cat.logError(ex);
                }
                if ((duration = System.currentTimeMillis() - start) < 0L || duration >= 1000L) continue;
                try {
                    Thread.sleep(1000L - duration);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        @Override
        public void shutdown() {
            this.active = false;
        }
    }
}

