/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.log;

import cn.com.duiba.cat.util.Properties;
import cn.com.duiba.cat.util.Threads;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;

public class CatLogger {
    private static final String DEFAULT_BASE_DIR = "/data/dbapplogs/cat";
    private static CatLogger LOGGER = new CatLogger();
    private MessageFormat format;
    private BufferedWriter writer;
    private String lastPath;
    private boolean devMode;
    private ReentrantLock lock = new ReentrantLock();

    private CatLogger() {
        String pattern = "[{0,date,MM-dd HH:mm:ss.SSS}] [{1}] [{3}] {2}";
        String mode = Properties.forString().fromSystem().fromEnv().getProperty("devMode", "false");
        this.format = new MessageFormat(pattern);
        this.devMode = Boolean.parseBoolean(mode);
    }

    public static CatLogger getInstance() {
        return LOGGER;
    }

    private void console(String message) {
        System.out.println(message);
    }

    public void error(String message) {
        this.out("ERROR", message, null);
    }

    public void error(String message, Throwable throwable) {
        this.out("ERROR", message, throwable);
    }

    private String formatMessage(String level, String message) {
        return this.format.format(new Object[]{new Date(), level, message, this.getCallerClassName()});
    }

    private String getCallerClassName() {
        String caller = Threads.getCallerClass();
        if (caller != null) {
            return caller;
        }
        StackTraceElement[] elements = new Exception().getStackTrace();
        if (elements.length > 1) {
            String className = elements[0].getClassName();
            int pos = className.lastIndexOf(36);
            if (pos < 0) {
                pos = className.lastIndexOf(46);
            }
            if (pos > 0) {
                return className.substring(pos + 1);
            }
            return className;
        }
        return "N/A";
    }

    private File getFilePath(String path) throws IOException {
        File file = new File(path);
        String baseDir = Properties.forString().fromSystem().fromEnv().getProperty("CAT_HOME", DEFAULT_BASE_DIR);
        if (baseDir != null) {
            file = new File(baseDir, path);
        }
        return file.getCanonicalFile();
    }

    private BufferedWriter getWriter() throws IOException {
        MessageFormat logFileFormat = new MessageFormat("cat_client_{0,date,yyyyMMdd}.log");
        String path = logFileFormat.format(new Object[]{new Date()});
        if (!path.equals(this.lastPath)) {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            File file = this.getFilePath(path);
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file, true);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));
            this.lastPath = path;
        }
        return this.writer;
    }

    public void info(String message) {
        this.out("INFO", message, null);
    }

    public void info(String message, Throwable throwable) {
        this.out("INFO", message, throwable);
    }

    public void warn(String message) {
        this.out("WARN", message, null);
    }

    public void warn(String message, Throwable throwable) {
        this.out("WARN", message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void out(String severity, String message, Throwable throwable) {
        block9: {
            this.lock.lock();
            try {
                String timedMessage = this.formatMessage(severity, message);
                if (this.devMode) {
                    this.console(timedMessage);
                    if (throwable != null) {
                        throwable.printStackTrace(System.out);
                    }
                    break block9;
                }
                try {
                    BufferedWriter writer = this.getWriter();
                    if (writer != null) {
                        writer.write(timedMessage);
                        writer.newLine();
                        if (throwable != null) {
                            throwable.printStackTrace(new PrintWriter(writer));
                        }
                        writer.flush();
                    }
                }
                catch (Exception e) {
                    this.console(this.formatMessage("ERROR", timedMessage + e.toString()));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

