/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.model.configuration.NetworkInterfaceManager;
import cn.com.duiba.cat.model.configuration.client.entity.ClientConfig;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.model.configuration.client.transform.DefaultSaxParser;
import cn.com.duiba.cat.util.Files;
import cn.com.duiba.cat.util.NetworkHelper;
import cn.com.duiba.cat.util.Splitters;
import cn.com.duiba.cat.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationEnvironment {
    private static final Logger LOGGER;
    public static final String ENVIRONMENT;
    public static final String CELL;
    public static final String VERSION = "2.0.1";
    private static final String HOST = "org.cat";
    private static final String PROPERTIES_FILE = "/META-INF/app.properties";
    private static final String CACHE_FILE = "client_cache.xml";
    private static final String CLIENT_FILE = "client.xml";

    private static boolean isDevMode() {
        String devMode = cn.com.duiba.cat.util.Properties.forString().fromEnv().fromSystem().getProperty("devMode", "false");
        return "true".equals(devMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAppName(String defaultDomain) {
        String appName = System.getProperty("cat.app.name");
        if (StringUtils.isNotEmpty(appName)) {
            return appName;
        }
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                in = Cat.class.getResourceAsStream(PROPERTIES_FILE);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                appName = prop.getProperty("app.name");
                if (appName != null) {
                    String string = appName;
                    return string;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return defaultDomain;
    }

    public static ClientConfig loadClientConfig(String domain) {
        String xml = null;
        try {
            ClientConfig config = ApplicationEnvironment.loadClientConfigBySystemProperty(domain);
            if (config != null) {
                return config;
            }
            File cacheFile = new File(Cat.getCatHome() + CACHE_FILE);
            File configFile = new File(Cat.getCatHome() + CLIENT_FILE);
            xml = cacheFile.exists() && !ApplicationEnvironment.isDevMode() ? Files.forIO().readFrom(cacheFile, "utf-8") : (configFile.exists() ? Files.forIO().readFrom(configFile, "utf-8") : ApplicationEnvironment.loadRemoteClientConfig());
            config = DefaultSaxParser.parse(xml);
            config.setDomain(domain);
            return config;
        }
        catch (Exception e) {
            LOGGER.info("load client config error: " + xml, (Throwable)e);
            File cacheFile = new File(Cat.getCatHome() + CACHE_FILE);
            if (cacheFile.exists()) {
                cacheFile.delete();
                return ApplicationEnvironment.loadClientConfig(domain);
            }
            throw new RuntimeException("Error when get cat router service, please contact cat support team for help!", e);
        }
    }

    private static ClientConfig loadClientConfigBySystemProperty(String domain) {
        String[] catServerArr;
        String catServers = System.getProperty("duiba.cat.server-list");
        if (StringUtils.isEmpty(catServers)) {
            return null;
        }
        ClientConfig config = new ClientConfig();
        config.setDomain(domain);
        for (String catServer : catServerArr = catServers.split(",")) {
            String[] ipPort = catServer.split(":");
            config.addServer(new Server(ipPort[0], Integer.parseInt(ipPort[1])));
        }
        return config;
    }

    public static String loadRemoteClientConfig() throws Exception {
        String host = cn.com.duiba.cat.util.Properties.forString().fromEnv().fromSystem().getProperty("CAT_HOST", HOST);
        String path = String.format("http://%s/cat/s/launch", host);
        String hostName = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        try {
            hostName = URLEncoder.encode(hostName, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String url = path + "?ip=" + NetworkInterfaceManager.INSTANCE.getLocalHostAddress() + "&env=" + ENVIRONMENT + "&hostname=" + hostName;
        return NetworkHelper.readFromUrlWithRetry(url);
    }

    public static void storeServers(String servers, int httpPort) {
        try {
            ClientConfig config = new ClientConfig();
            List<String> strs = Splitters.by(";").noEmptyItem().split(servers);
            for (String str : strs) {
                List<String> items = Splitters.by(":").noEmptyItem().split(str);
                config.addServer(new Server().setIp(items.get(0)).setHttpPort(httpPort).setPort(Integer.parseInt(items.get(1))));
            }
            config.setDomain(null);
            Files.forIO().writeTo(new File(Cat.getCatHome() + CACHE_FILE), config.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String cell;
        String env;
        LOGGER = LoggerFactory.getLogger(ApplicationEnvironment.class);
        try {
            String file = "/data/webapps/appenv";
            Properties pro = new Properties();
            pro.load(new FileInputStream(new File(file)));
            env = pro.getProperty("env");
            if (StringUtils.isEmpty(env)) {
                env = pro.getProperty("deployenv");
            }
            cell = pro.getProperty("cell");
        }
        catch (Exception e) {
            env = "unknown";
            cell = "";
        }
        if (env == null) {
            env = "unknown";
        }
        if (cell == null) {
            cell = "";
        }
        ENVIRONMENT = env.trim();
        CELL = cell.trim();
    }
}

