/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.message.Event;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.MessageType;
import cn.com.duiba.cat.util.Splitters;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MessageTreeTypeParser {
    private ConcurrentHashMap<String, MessageType> messageTypes = new ConcurrentHashMap();
    private List<String> startTypes;
    private List<String> matchTypes;
    private String lastStartType;
    private String lastMatchType;

    public MessageType parseMessageType(MessageTree tree) {
        Message message = tree.getMessage();
        if (message instanceof Transaction) {
            String type = message.getType();
            MessageType messageType = this.messageTypes.get(type);
            if (messageType != null) {
                return messageType;
            }
            if (this.startTypes != null) {
                for (String s : this.startTypes) {
                    if (!type.startsWith(s)) continue;
                    messageType = MessageType.SMALL_TRANSACTION;
                    break;
                }
            }
            if (this.matchTypes != null && this.matchTypes.contains(type)) {
                messageType = MessageType.SMALL_TRANSACTION;
            }
            if (messageType == null) {
                messageType = MessageType.NORMAL_MESSAGE;
            }
            this.messageTypes.put(type, messageType);
            return messageType;
        }
        if (message instanceof Event) {
            return MessageType.STAND_ALONE_EVENT;
        }
        return MessageType.NORMAL_MESSAGE;
    }

    public void refresh(String startTypes, String matchTypes) {
        if (startTypes != null && !startTypes.equals(this.lastStartType)) {
            this.startTypes = Splitters.by(";").noEmptyItem().split(startTypes);
            this.lastStartType = startTypes;
        }
        if (matchTypes != null && !matchTypes.equals(this.lastMatchType)) {
            this.matchTypes = Splitters.by(";").noEmptyItem().split(matchTypes);
            this.lastMatchType = matchTypes;
        }
    }
}

