/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.util;

import cn.com.duiba.cat.util.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Scanners {
    public static DirScanner forDir() {
        return DirScanner.INSTANCE;
    }

    public static JarScanner forJar() {
        return JarScanner.INSTANCE;
    }

    public static abstract class DirMatcher
    implements IMatcher<File> {
        @Override
        public boolean isDirEligible() {
            return true;
        }

        @Override
        public boolean isFileElegible() {
            return false;
        }
    }

    public static abstract class FileMatcher
    implements IMatcher<File> {
        @Override
        public boolean isDirEligible() {
            return false;
        }

        @Override
        public boolean isFileElegible() {
            return true;
        }
    }

    public static abstract class ZipEntryMatcher
    implements IMatcher<ZipEntry> {
        @Override
        public boolean isDirEligible() {
            return false;
        }

        @Override
        public boolean isFileElegible() {
            return true;
        }

        @Override
        public abstract IMatcher.Direction matches(ZipEntry var1, String var2);
    }

    public static interface IMatcher<T> {
        public boolean isDirEligible();

        public boolean isFileElegible();

        public Direction matches(T var1, String var2);

        public static enum Direction {
            MATCHED,
            DOWN,
            NEXT;


            public boolean isDown() {
                return this == DOWN;
            }

            public boolean isMatched() {
                return this == MATCHED;
            }

            public boolean isNext() {
                return this == NEXT;
            }
        }
    }

    public static enum DirScanner {
        INSTANCE;


        public List<File> scan(File base, IMatcher<File> matcher) {
            ArrayList<File> files = new ArrayList<File>();
            StringBuilder relativePath = new StringBuilder();
            this.scanForFiles(base, relativePath, matcher, false, files);
            return files;
        }

        private void scanForFiles(File base, StringBuilder relativePath, IMatcher<File> matcher, boolean foundFirst, List<File> files) {
            int len = relativePath.length();
            File dir = len == 0 ? base : new File(base, relativePath.toString());
            String[] list = dir.list();
            if (list != null) {
                String[] var9 = list;
                int var10 = list.length;
                for (int var11 = 0; var11 < var10; ++var11) {
                    IMatcher.Direction direction;
                    String item = var9[var11];
                    File child = new File(dir, item);
                    if (len > 0) {
                        relativePath.append('/');
                    }
                    relativePath.append(item);
                    if (matcher.isDirEligible() && child.isDirectory()) {
                        direction = matcher.matches(base, relativePath.toString());
                        switch (direction) {
                            case MATCHED: {
                                files.add(child);
                                break;
                            }
                            case DOWN: {
                                this.scanForFiles(base, relativePath, matcher, foundFirst, files);
                            }
                        }
                    } else if (matcher.isFileElegible()) {
                        direction = matcher.matches(base, relativePath.toString());
                        switch (direction) {
                            case MATCHED: {
                                if (!child.isFile()) break;
                                files.add(child);
                                break;
                            }
                            case DOWN: {
                                if (!child.isDirectory()) break;
                                this.scanForFiles(base, relativePath, matcher, foundFirst, files);
                            }
                        }
                    }
                    relativePath.setLength(len);
                    if (foundFirst && files.size() > 0) break;
                }
            }
        }

        public File scanForOne(File base, IMatcher<File> matcher) {
            ArrayList<File> files = new ArrayList<File>(1);
            StringBuilder relativePath = new StringBuilder();
            this.scanForFiles(base, relativePath, matcher, true, files);
            return files.isEmpty() ? null : (File)files.get(0);
        }
    }

    public static enum JarScanner {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZipEntry getEntry(String jarFileName, String name) {
            ZipFile zipFile = null;
            try {
                ZipEntry entry;
                ZipEntry var5;
                zipFile = new ZipFile(jarFileName);
                ZipEntry zipEntry = var5 = (entry = zipFile.getEntry(name));
                return zipEntry;
            }
            catch (IOException iOException) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getEntryContent(String jarFileName, String entryPath) {
            byte[] bytes = null;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jarFileName);
                ZipEntry entry = zipFile.getEntry(entryPath);
                if (entry != null) {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    bytes = Files.forIO().readFrom(inputStream);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return bytes;
        }

        public boolean hasEntry(String jarFileName, String name) {
            return this.getEntry(jarFileName, name) != null;
        }

        public List<String> scan(File base, IMatcher<File> matcher) {
            ArrayList<String> files = new ArrayList<String>();
            this.scanForFiles(base, matcher, false, files);
            return files;
        }

        public List<String> scan(ZipFile zipFile, IMatcher<ZipEntry> matcher) {
            ArrayList<String> files = new ArrayList<String>();
            this.scanForEntries(zipFile, matcher, false, files);
            return files;
        }

        private void scanForEntries(ZipFile zipFile, IMatcher<ZipEntry> matcher, boolean foundFirst, List<String> names) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                IMatcher.Direction direction;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (matcher.isDirEligible() && entry.isDirectory()) {
                    direction = matcher.matches(entry, name);
                    if (direction.isMatched()) {
                        names.add(name);
                    }
                } else if (matcher.isFileElegible() && !entry.isDirectory() && (direction = matcher.matches(entry, name)).isMatched()) {
                    names.add(name);
                }
                if (!foundFirst || names.size() <= 0) continue;
                break;
            }
        }

        private void scanForFiles(File jarFile, IMatcher<File> matcher, boolean foundFirst, List<String> names) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jarFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (zipFile != null) {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    IMatcher.Direction direction;
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (matcher.isDirEligible() && entry.isDirectory()) {
                        direction = matcher.matches(jarFile, name);
                        if (direction.isMatched()) {
                            names.add(name);
                        }
                    } else if (matcher.isFileElegible() && !entry.isDirectory() && (direction = matcher.matches(jarFile, name)).isMatched()) {
                        names.add(name);
                    }
                    if (!foundFirst || names.size() <= 0) continue;
                    break;
                }
            }
        }

        public String scanForOne(File jarFile, IMatcher<File> matcher) {
            ArrayList<String> files = new ArrayList<String>(1);
            this.scanForFiles(jarFile, matcher, true, files);
            return files.isEmpty() ? null : (String)files.get(0);
        }
    }
}

