/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.util;

import java.util.ArrayList;
import java.util.List;

public class Splitters {
    public static StringSplitter by(char delimiter) {
        return new StringSplitter(delimiter);
    }

    public static StringSplitter by(String delimiter) {
        return new StringSplitter(delimiter);
    }

    public static class StringSplitter {
        private char charDelimiter;
        private String stringDelimiter;
        private boolean trimmed;
        private boolean noEmptyItem;

        StringSplitter(char delimiter) {
            this.charDelimiter = delimiter;
        }

        StringSplitter(String delimiter) {
            this.stringDelimiter = delimiter;
        }

        List<String> doCharSplit(String str, List<String> list) {
            char delimiter = this.charDelimiter;
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len + 1; ++i) {
                char ch;
                char c = ch = i == len ? delimiter : str.charAt(i);
                if (ch == delimiter) {
                    String item = sb.toString();
                    sb.setLength(0);
                    if (this.trimmed) {
                        item = item.trim();
                    }
                    if (this.noEmptyItem && item.length() == 0) continue;
                    list.add(item);
                    continue;
                }
                sb.append(ch);
            }
            return list;
        }

        List<String> doStringSplit(String source, List<String> list) {
            String delimiter = this.stringDelimiter;
            int len = delimiter.length();
            int offset = 0;
            int index = source.indexOf(delimiter, offset);
            while (true) {
                String part = index == -1 ? source.substring(offset) : source.substring(offset, index);
                if (this.trimmed) {
                    part = part.trim();
                }
                if (!this.noEmptyItem || part.length() > 0) {
                    list.add(part);
                }
                if (index == -1) break;
                offset = index + len;
                index = source.indexOf(delimiter, offset);
            }
            return list;
        }

        public StringSplitter noEmptyItem() {
            this.noEmptyItem = true;
            return this;
        }

        public List<String> split(String str) {
            return this.split(str, new ArrayList<String>());
        }

        public List<String> split(String str, List<String> list) {
            if (str == null) {
                return null;
            }
            if (this.charDelimiter > '\u0000') {
                return this.doCharSplit(str, list);
            }
            if (this.stringDelimiter != null) {
                return this.doStringSplit(str, list);
            }
            throw new UnsupportedOperationException();
        }

        public StringSplitter trim() {
            this.trimmed = true;
            return this;
        }
    }
}

