/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import cn.com.duiba.cat.model.configuration.client.entity.Bind;
import cn.com.duiba.cat.model.configuration.client.entity.Domain;
import cn.com.duiba.cat.model.configuration.client.entity.Property;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.model.configuration.client.transform.DefaultXmlBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ClientConfig
extends BaseEntity<ClientConfig> {
    private String mode;
    private boolean enabled = true;
    private Boolean dumpLocked;
    private List<Server> servers = new ArrayList<Server>();
    private Map<String, Domain> domains = new LinkedHashMap<String, Domain>();
    private Bind bind;
    private List<Property> properties = new ArrayList<Property>();
    private String domain = "unknown";
    private int maxMessageSize = 5000;

    public ClientConfig() {
    }

    public ClientConfig(String domain) {
        if (domain != null) {
            this.domain = domain;
        }
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitConfig(this);
    }

    public ClientConfig addDomain(Domain domain) {
        this.domains.put(domain.getId(), domain);
        return this;
    }

    public ClientConfig addProperty(Property property) {
        this.properties.add(property);
        return this;
    }

    public ClientConfig addServer(Server server) {
        this.servers.add(server);
        return this;
    }

    public Domain findDomain(String id) {
        return this.domains.get(id);
    }

    public Server findServer(String ip) {
        for (Server server : this.servers) {
            if (!server.getIp().equals(ip)) continue;
            return server;
        }
        return null;
    }

    @Override
    public void mergeAttributes(ClientConfig other) {
        this.assertAttributeEquals(other, "config", "domain", this.domain, other.getDomain());
        if (other.getMode() != null) {
            this.mode = other.getMode();
        }
        this.enabled = other.isEnabled();
        if (other.getDumpLocked() != null) {
            this.dumpLocked = other.getDumpLocked();
        }
        this.maxMessageSize = other.getMaxMessageSize();
    }

    public boolean removeDomain(String id) {
        if (this.domains.containsKey(id)) {
            this.domains.remove(id);
            return true;
        }
        return false;
    }

    public boolean removeServer(String ip) {
        int len = this.servers.size();
        for (int i = 0; i < len; ++i) {
            Server server = this.servers.get(i);
            if (!server.getIp().equals(ip)) continue;
            this.servers.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new DefaultXmlBuilder().buildXml(this);
    }

    public String getMode() {
        return this.mode;
    }

    public ClientConfig setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClientConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getDumpLocked() {
        return this.dumpLocked;
    }

    public ClientConfig setDumpLocked(Boolean dumpLocked) {
        this.dumpLocked = dumpLocked;
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public Map<String, Domain> getDomains() {
        return this.domains;
    }

    public void setDomains(Map<String, Domain> domains) {
        this.domains = domains;
    }

    public Bind getBind() {
        return this.bind;
    }

    public ClientConfig setBind(Bind bind) {
        this.bind = bind;
        return this;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public String getDomain() {
        return this.domain;
    }

    public ClientConfig setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public ClientConfig setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConfig that = (ClientConfig)o;
        return new EqualsBuilder().append(this.enabled, that.enabled).append(this.maxMessageSize, that.maxMessageSize).append((Object)this.mode, (Object)that.mode).append((Object)this.dumpLocked, (Object)that.dumpLocked).append(this.servers, that.servers).append(this.domains, that.domains).append((Object)this.bind, (Object)that.bind).append(this.properties, that.properties).append((Object)this.domain, (Object)that.domain).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.mode).append(this.enabled).append((Object)this.dumpLocked).append(this.servers).append(this.domains).append((Object)this.bind).append(this.properties).append((Object)this.domain).append(this.maxMessageSize).toHashCode();
    }
}

