/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MemoryInformation {
    private static final String DIRECT_BUFFER_MBEAN = "java.nio:type=BufferPool,name=direct";
    private static final String MAPPED_BUFFER_MBEAN = "java.nio:type=BufferPool,name=mapped";
    private final long usedMemory;
    private final long maxMemory;
    private final long usedOldGen;
    private final long maxOldGen;
    private final long usedPermGen;
    private final long maxPermGen;
    private final long usedEdenSpace;
    private final long maxEdenSpace;
    private final long usedSurvivorSpace;
    private final long maxSurvivorSpace;
    private final long usedMetaSpace;
    private final long maxMetaSpace;
    private final long usedNonHeapMemory;
    private final long maxNonHeapMemory;
    private long usedCodeCache;
    private long maxCodeCache;
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();

    public MemoryInformation() {
        this.usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.maxMemory = Runtime.getRuntime().maxMemory();
        MemoryPoolMXBean permGenMemoryPool = this.getPermGenMemoryPool();
        if (permGenMemoryPool != null) {
            MemoryUsage usage = permGenMemoryPool.getUsage();
            this.usedPermGen = usage.getUsed();
            this.maxPermGen = usage.getMax();
        } else {
            this.usedPermGen = 0L;
            this.maxPermGen = 0L;
        }
        MemoryPoolMXBean metaSpaceMemoryPool = this.getMetaspaceMemoryPool();
        if (metaSpaceMemoryPool != null) {
            MemoryUsage usage = metaSpaceMemoryPool.getUsage();
            this.usedMetaSpace = usage.getUsed();
            this.maxMetaSpace = usage.getMax();
        } else {
            this.usedMetaSpace = 0L;
            this.maxMetaSpace = 0L;
        }
        MemoryPoolMXBean codeCacheMemoryPool = this.getCodeCacheMemoryPool();
        if (codeCacheMemoryPool != null) {
            MemoryUsage usage = codeCacheMemoryPool.getUsage();
            this.usedCodeCache = usage.getUsed();
            this.maxCodeCache = usage.getMax();
        } else {
            this.usedCodeCache = 0L;
            this.maxCodeCache = 0L;
        }
        MemoryPoolMXBean oldGenMemoryPool = this.getOldGenMemoryPool();
        if (oldGenMemoryPool != null) {
            MemoryUsage usage = oldGenMemoryPool.getUsage();
            this.usedOldGen = usage.getUsed();
            this.maxOldGen = usage.getMax();
        } else {
            this.usedOldGen = 0L;
            this.maxOldGen = 0L;
        }
        MemoryPoolMXBean edenSpaceMemoryPool = this.getEdenSpacePool();
        if (edenSpaceMemoryPool != null) {
            MemoryUsage usage = edenSpaceMemoryPool.getUsage();
            this.usedEdenSpace = usage.getUsed();
            this.maxEdenSpace = usage.getMax();
        } else {
            this.usedEdenSpace = 0L;
            this.maxEdenSpace = 0L;
        }
        MemoryPoolMXBean survivorSpacePool = this.getSurvivorSpaceMemoryPool();
        if (survivorSpacePool != null) {
            MemoryUsage usage = survivorSpacePool.getUsage();
            this.usedSurvivorSpace = usage.getUsed();
            this.maxSurvivorSpace = usage.getMax();
        } else {
            this.usedSurvivorSpace = 0L;
            this.maxSurvivorSpace = 0L;
        }
        MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        this.usedNonHeapMemory = nonHeapMemoryUsage.getUsed();
        this.maxNonHeapMemory = nonHeapMemoryUsage.getMax();
    }

    private MemoryPoolMXBean getCodeCacheMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Code Cache")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getEdenSpacePool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Eden Space")) continue;
            return memoryPool;
        }
        return null;
    }

    public long getMaxEdenSpace() {
        return this.maxEdenSpace;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxNonHeapMemory() {
        return this.maxNonHeapMemory;
    }

    public long getMaxOldGen() {
        return this.maxOldGen;
    }

    public long getMaxPermGen() {
        return this.maxPermGen;
    }

    public long getMaxSurvivorSpace() {
        return this.maxSurvivorSpace;
    }

    private MemoryPoolMXBean getMetaspaceMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Metaspace")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getOldGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Old Gen")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getPermGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Perm Gen")) continue;
            return memoryPool;
        }
        return null;
    }

    private MemoryPoolMXBean getSurvivorSpaceMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memoryPool.getName().endsWith("Survivor Space")) continue;
            return memoryPool;
        }
        return null;
    }

    public long getUsedCodeCache() {
        return this.usedCodeCache;
    }

    public double getUsedCodeCachePercentage() {
        if (this.usedCodeCache > 0L && this.maxCodeCache > 0L) {
            return 100.0 * (double)this.usedCodeCache / (double)this.maxCodeCache;
        }
        return 0.0;
    }

    public long getUsedDirectBufferSize() {
        long directBufferSize = 0L;
        try {
            ObjectName directPool = new ObjectName(DIRECT_BUFFER_MBEAN);
            directBufferSize = (Long)this.mbeanServer.getAttribute(directPool, "MemoryUsed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return directBufferSize;
    }

    public long getUsedEdenSpace() {
        return this.usedEdenSpace;
    }

    public double getUsedEdenSpacePercentage() {
        if (this.usedEdenSpace > 0L && this.maxEdenSpace > 0L) {
            return 100.0 * (double)this.usedEdenSpace / (double)this.maxEdenSpace;
        }
        return 0.0;
    }

    public long getUsedMappedSize() {
        long mappedBufferSize = 0L;
        try {
            ObjectName directPool = new ObjectName(MAPPED_BUFFER_MBEAN);
            mappedBufferSize = (Long)this.mbeanServer.getAttribute(directPool, "MemoryUsed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mappedBufferSize;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public double getUsedMemoryPercentage() {
        return 100.0 * (double)this.usedMemory / (double)this.maxMemory;
    }

    public long getUsedMetaSpace() {
        return this.usedMetaSpace;
    }

    public double getUsedMetaSpacePercentage() {
        if (this.usedMetaSpace > 0L && this.maxMetaSpace > 0L) {
            return 100.0 * (double)this.usedMetaSpace / (double)this.maxMetaSpace;
        }
        return 0.0;
    }

    public long getUsedNonHeapMemory() {
        return this.usedNonHeapMemory;
    }

    public double getUsedNonHeapPercentage() {
        if (this.usedNonHeapMemory > 0L && this.maxNonHeapMemory > 0L) {
            return 100.0 * (double)this.usedNonHeapMemory / (double)this.maxNonHeapMemory;
        }
        return 0.0;
    }

    public long getUsedOldGen() {
        return this.usedOldGen;
    }

    public double getUsedOldGenPercentage() {
        if (this.usedOldGen > 0L && this.maxOldGen > 0L) {
            return 100.0 * (double)this.usedOldGen / (double)this.maxOldGen;
        }
        return 0.0;
    }

    public long getUsedPermGen() {
        return this.usedPermGen;
    }

    public double getUsedPermGenPercentage() {
        if (this.usedPermGen > 0L && this.maxPermGen > 0L) {
            return 100.0 * (double)this.usedPermGen / (double)this.maxPermGen;
        }
        return 0.0;
    }

    public long getUsedSurvivorSpace() {
        return this.usedSurvivorSpace;
    }

    public double getUsedSurvivorSpacePercentage() {
        if (this.usedSurvivorSpace > 0L && this.maxSurvivorSpace > 0L) {
            return 100.0 * (double)this.usedSurvivorSpace / (double)this.maxSurvivorSpace;
        }
        return 0.0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[usedMemory=" + this.getUsedMemory() + ", maxMemroy=" + this.getMaxMemory() + ']';
    }
}

