/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.util.json;

import cn.com.duiba.cat.util.json.JsonArray;
import cn.com.duiba.cat.util.json.JsonTokener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class JsonObject {
    public static final Object NULL = new Null();
    private HashMap<String, Object> myHashMap;

    public JsonObject() {
        this.myHashMap = new HashMap();
    }

    public JsonObject(JsonObject jo, String[] sa) {
        this();
        for (int i = 0; i < sa.length; ++i) {
            this.putOpt(sa[i], jo.opt(sa[i]));
        }
    }

    public JsonObject(JsonTokener x) throws ParseException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.myHashMap.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JsonObject(Map<String, Object> map) {
        this.myHashMap = new HashMap<String, Object>(map);
    }

    public JsonObject(String string) throws ParseException {
        this(new JsonTokener(string));
    }

    public static String numberToString(Number n) throws ArithmeticException {
        if (n instanceof Float && (((Float)n).isInfinite() || ((Float)n).isNaN()) || n instanceof Double && (((Double)n).isInfinite() || ((Double)n).isNaN())) {
            throw new ArithmeticException("JSON can only serialize finite numbers.");
        }
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static String quote(String str) {
        int length = str == null ? 4 : str.length() + 4;
        StringBuilder sb = new StringBuilder(length);
        JsonObject.appendQuoted(str, sb);
        return sb.toString();
    }

    protected static StringBuilder appendQuoted(String str, StringBuilder sb) {
        if (str == null || str.length() == 0) {
            sb.append("\"\"");
            return sb;
        }
        sb.append('\"');
        JsonObject.escape(str, false, true, sb);
        sb.append('\"');
        return sb;
    }

    protected static int getQuotedSize(String str) {
        if (str == null || str.length() == 0) {
            return 2;
        }
        return (int)(1.3 * (double)str.length());
    }

    public static String escape(String string) {
        return JsonObject.escape(string, false);
    }

    public static String escape(String str, boolean singleQuote) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        JsonObject.escape(str, singleQuote, false, sb);
        return sb.toString();
    }

    private static void escape(String str, boolean singleQuote, boolean handleSlash, StringBuilder sb) {
        char c = '\u0000';
        int len = str.length();
        block10: for (int i = 0; i < len; ++i) {
            char b = c;
            c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    if (!singleQuote) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block10;
                }
                case '\'': {
                    if (singleQuote) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block10;
                }
                case '/': {
                    if (handleSlash && b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block10;
                }
                case '\b': {
                    sb.append('\\').append('b');
                    continue block10;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
    }

    static String valueToString(Object value) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JsonObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JsonArray || JsonObject.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        if (!(value instanceof String)) {
            return value.toString();
        }
        return JsonObject.quote(value.toString());
    }

    protected static StringBuilder appendValue(Object value, StringBuilder sb) {
        if (value == null || value.equals(null)) {
            return sb.append("null");
        }
        if (value instanceof String) {
            return JsonObject.appendQuoted((String)value, sb);
        }
        if (value instanceof Number) {
            return sb.append(JsonObject.numberToString((Number)value));
        }
        if (value instanceof Boolean) {
            return sb.append((Boolean)value);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).append(sb);
        }
        if (JsonObject.class.isAssignableFrom(value.getClass())) {
            return ((JsonObject)value).append(sb);
        }
        return sb.append(value.toString());
    }

    protected static int getValueSize(Object value) {
        if (value == null || value.equals(null)) {
            return 4;
        }
        if (value instanceof Number) {
            return 12;
        }
        if (value instanceof Boolean) {
            return 5;
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).getSerializedSize();
        }
        if (JsonObject.class.isAssignableFrom(value.getClass())) {
            return ((JsonObject)value).getSerializedSize();
        }
        if (!(value instanceof String)) {
            return 32;
        }
        return JsonObject.getQuotedSize((String)value);
    }

    static String valueToString(Object value, int indentFactor, int indent) {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JsonObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (JsonObject.class.isAssignableFrom(value.getClass())) {
            return ((JsonObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        return JsonObject.quote(value.toString());
    }

    public JsonObject accumulate(String key, Object value) throws NullPointerException {
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value);
        } else if (o instanceof JsonArray) {
            JsonArray a = (JsonArray)o;
            a.put(value);
        } else {
            JsonArray a = new JsonArray();
            a.put(o);
            a.put(value);
            this.put(key, a);
        }
        return this;
    }

    public Object get(String key) throws NoSuchElementException {
        Object o = this.opt(key);
        if (o == null) {
            throw new NoSuchElementException("JSONObject[" + JsonObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws ClassCastException, NoSuchElementException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new ClassCastException("JSONObject[" + JsonObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return new Double((String)o);
        }
        throw new NumberFormatException("JSONObject[" + JsonObject.quote(key) + "] is not a number.");
    }

    public long getLong(String key) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(key);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return new Long((String)o);
        }
        throw new NumberFormatException("JSONObject[" + JsonObject.quote(key) + "] is not a number.");
    }

    HashMap<String, Object> getHashMap() {
        return this.myHashMap;
    }

    public int getInt(String key) throws NoSuchElementException, NumberFormatException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JsonArray getJSONArray(String key) throws NoSuchElementException {
        Object o = this.get(key);
        if (o instanceof JsonArray) {
            return (JsonArray)o;
        }
        throw new NoSuchElementException("JSONObject[" + JsonObject.quote(key) + "] is not a JSONArray.");
    }

    public JsonObject getJSONObject(String key) throws NoSuchElementException {
        Object o = this.get(key);
        if (o instanceof JsonObject) {
            return (JsonObject)o;
        }
        throw new NoSuchElementException("JSONObject[" + JsonObject.quote(key) + "] is not a JSONObject.");
    }

    public String getString(String key) throws NoSuchElementException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator<String> keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JsonArray names() {
        JsonArray ja = new JsonArray();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public Object opt(String key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Null key");
        }
        return this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        return defaultValue;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            try {
                return new Double((String)o);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        Object o = this.opt(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public JsonArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JsonArray ? (JsonArray)o : null;
    }

    public JsonObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JsonObject ? (JsonObject)o : null;
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JsonObject put(String key, boolean value) {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonObject put(String key, double value) {
        this.put(key, new Double(value));
        return this;
    }

    public JsonObject put(String key, int value) {
        this.put(key, new Integer(value));
        return this;
    }

    public JsonObject put(String key, Object value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JsonObject putOpt(String key, Object value) throws NullPointerException {
        if (value != null) {
            this.put(key, value);
        }
        return this;
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    public JsonArray toJSONArray(JsonArray names) {
        if (names == null || names.length() == 0) {
            return null;
        }
        JsonArray ja = new JsonArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getSerializedSize());
        return this.append(sb).toString();
    }

    public StringBuilder append(StringBuilder sb) {
        sb.append('{');
        boolean firstEntry = true;
        for (Map.Entry<String, Object> entry : this.myHashMap.entrySet()) {
            if (!firstEntry) {
                sb.append(',');
            } else {
                firstEntry = false;
            }
            JsonObject.appendQuoted(entry.getKey(), sb);
            sb.append(':');
            JsonObject.appendValue(entry.getValue(), sb);
        }
        sb.append('}');
        return sb;
    }

    private int getSerializedSize() {
        int value = 2 + this.length() * 2;
        for (Map.Entry<String, Object> entry : this.myHashMap.entrySet()) {
            value += JsonObject.getQuotedSize(entry.getKey()) + JsonObject.getValueSize(entry.getValue());
        }
        return (int)(1.2 * (double)value);
    }

    public String toString(int indentFactor) {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator<String> keys = this.keys();
        StringBuilder sb = new StringBuilder("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            String key = keys.next();
            sb.append(JsonObject.quote(key));
            sb.append(": ");
            sb.append(JsonObject.valueToString(this.myHashMap.get(key), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                String key = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JsonObject.quote(key));
                sb.append(": ");
                sb.append(JsonObject.valueToString(this.myHashMap.get(key), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "null";
        }
    }
}

