package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.message.Event;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.util.Splitters;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class MessageTreeTypeParser {

    private ConcurrentHashMap<String, MessageType> messageTypes = new ConcurrentHashMap<String, MessageType>();
    private List<String>                           startTypes;
    private List<String>                           matchTypes;
    private String                                 lastStartType;
    private String                                 lastMatchType;

    public MessageType parseMessageType(MessageTree tree) {
        Message message = tree.getMessage();

        if (message instanceof Transaction) {
            String type = message.getType();
            MessageType messageType = messageTypes.get(type);

            if (messageType != null) {
                return messageType;
            } else {
                if (startTypes != null) {
                    for (String s : startTypes) {
                        if (type.startsWith(s)) {
                            messageType = MessageType.SMALL_TRANSACTION;
                            break;
                        }
                    }
                }
                if (matchTypes != null && matchTypes.contains(type)) {
                    messageType = MessageType.SMALL_TRANSACTION;
                }
                if (messageType == null) {
                    messageType = MessageType.NORMAL_MESSAGE;
                }

                messageTypes.put(type, messageType);

                return messageType;
            }
        } else if (message instanceof Event) {
            return MessageType.STAND_ALONE_EVENT;
        } else {
            return MessageType.NORMAL_MESSAGE;
        }
    }

    public void refresh(String startTypes, String matchTypes) {
        if (startTypes != null && !startTypes.equals(lastStartType)) {
            this.startTypes = Splitters.by(";").noEmptyItem().split(startTypes);
            lastStartType = startTypes;
        }

        if (matchTypes != null && !matchTypes.equals(lastMatchType)) {
            this.matchTypes = Splitters.by(";").noEmptyItem().split(matchTypes);
            lastMatchType = matchTypes;
        }
    }
}
