package cn.com.duiba.cat.status.datasource.druid;

public class DruidMonitorInfo {

    private String jdbcUrl;
    private int    activeCount;
    private int    poolingCount;
    private int    maxActive;
    private int    maxIdle;
    private int    maxOpenPreparedStatements;
    private int    maxPoolPreparedStatementPerConnectionSize;
    private long   maxWait;
    private int    maxWaitThreadCount;
    private int    minIdle;
    private int    queryTimeout;
    private int    notEmptyWaitThreadCount;
    private int    waitThreadCount;
    private long   notEmptyWaitCount;
    private long   notEmptyWaitMillis;
    private long   startTransactionCount;
    private long   recycleCount;
    private long   rollbackCount;
    private long   closeCount;
    private long   closedPreparedStatementCount;
    private long   commitCount;
    private long   connectCount;
    private long   connectErrorCount;
    private long   createCount;
    private long   createErrorCount;
    private long   destroyCount;
    private long   discardCount;
    private long   dupCloseCount;
    private long   errorCount;
    private long   initialSize;
    private int    lockQueueLength;
    private long   createTimeSpanMillis;
    private long   removeAbandonedCount;

    long getAvgCreateTimeSpanMillis() {
        if (createCount > 0) {
            return createTimeSpanMillis / createCount;
        } else {
            return 0;
        }
    }

    long getAvgNotEmptyWaitMillis() {
        if (notEmptyWaitCount > 0) {
            return notEmptyWaitMillis / notEmptyWaitCount;
        } else {
            return 0;
        }
    }

    @Override
    public String toString() {
        return "DruidMonitorInfo [jdbcUrl=" + jdbcUrl + ", activeCount=" + activeCount + ", poolingCount=" + poolingCount + ", maxActive=" + maxActive + ", maxIdle=" + maxIdle + ", maxOpenPreparedStatements=" + maxOpenPreparedStatements + ", maxPoolPreparedStatementPerConnectionSize=" + maxPoolPreparedStatementPerConnectionSize + ", maxWait=" + maxWait + ", maxWaitThreadCount=" + maxWaitThreadCount + ", minIdle=" + minIdle + ", queryTimeout=" + queryTimeout + ", notEmptyWaitThreadCount=" + notEmptyWaitThreadCount + ", waitThreadCount=" + waitThreadCount + ", notEmptyWaitCount=" + notEmptyWaitCount + ", notEmptyWaitMillis=" + notEmptyWaitMillis + ", startTransactionCount=" + startTransactionCount + ", recycleCount=" + recycleCount + ", rollbackCount=" + rollbackCount + ", closeCount=" + closeCount + ", closedPreparedStatementCount=" + closedPreparedStatementCount + ", commitCount=" + commitCount + ", connectCount=" + connectCount + ", connectErrorCount=" + connectErrorCount + ", createCount=" + createCount + ", createErrorCount=" + createErrorCount + ", destroyCount=" + destroyCount + ", discardCount=" + discardCount + ", dupCloseCount=" + dupCloseCount + ", errorCount=" + errorCount + ", initialSize=" + initialSize + ", lockQueueLength=" + lockQueueLength + ", createTimeSpanMillis=" + createTimeSpanMillis + ", removeAbandonedCount=" + removeAbandonedCount + "]";
    }

    public String getJdbcUrl() {
        return jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public int getActiveCount() {
        return activeCount;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public int getPoolingCount() {
        return poolingCount;
    }

    public void setPoolingCount(int poolingCount) {
        this.poolingCount = poolingCount;
    }

    public int getMaxActive() {
        return maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxOpenPreparedStatements() {
        return maxOpenPreparedStatements;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public int getMaxPoolPreparedStatementPerConnectionSize() {
        return maxPoolPreparedStatementPerConnectionSize;
    }

    public void setMaxPoolPreparedStatementPerConnectionSize(int maxPoolPreparedStatementPerConnectionSize) {
        this.maxPoolPreparedStatementPerConnectionSize = maxPoolPreparedStatementPerConnectionSize;
    }

    public long getMaxWait() {
        return maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public int getMaxWaitThreadCount() {
        return maxWaitThreadCount;
    }

    public void setMaxWaitThreadCount(int maxWaitThreadCount) {
        this.maxWaitThreadCount = maxWaitThreadCount;
    }

    public int getMinIdle() {
        return minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getQueryTimeout() {
        return queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getNotEmptyWaitThreadCount() {
        return notEmptyWaitThreadCount;
    }

    public void setNotEmptyWaitThreadCount(int notEmptyWaitThreadCount) {
        this.notEmptyWaitThreadCount = notEmptyWaitThreadCount;
    }

    public int getWaitThreadCount() {
        return waitThreadCount;
    }

    public void setWaitThreadCount(int waitThreadCount) {
        this.waitThreadCount = waitThreadCount;
    }

    public long getNotEmptyWaitCount() {
        return notEmptyWaitCount;
    }

    public void setNotEmptyWaitCount(long notEmptyWaitCount) {
        this.notEmptyWaitCount = notEmptyWaitCount;
    }

    public long getNotEmptyWaitMillis() {
        return notEmptyWaitMillis;
    }

    public void setNotEmptyWaitMillis(long notEmptyWaitMillis) {
        this.notEmptyWaitMillis = notEmptyWaitMillis;
    }

    public long getStartTransactionCount() {
        return startTransactionCount;
    }

    public void setStartTransactionCount(long startTransactionCount) {
        this.startTransactionCount = startTransactionCount;
    }

    public long getRecycleCount() {
        return recycleCount;
    }

    public void setRecycleCount(long recycleCount) {
        this.recycleCount = recycleCount;
    }

    public long getRollbackCount() {
        return rollbackCount;
    }

    public void setRollbackCount(long rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    public long getCloseCount() {
        return closeCount;
    }

    public void setCloseCount(long closeCount) {
        this.closeCount = closeCount;
    }

    public long getClosedPreparedStatementCount() {
        return closedPreparedStatementCount;
    }

    public void setClosedPreparedStatementCount(long closedPreparedStatementCount) {
        this.closedPreparedStatementCount = closedPreparedStatementCount;
    }

    public long getCommitCount() {
        return commitCount;
    }

    public void setCommitCount(long commitCount) {
        this.commitCount = commitCount;
    }

    public long getConnectCount() {
        return connectCount;
    }

    public void setConnectCount(long connectCount) {
        this.connectCount = connectCount;
    }

    public long getConnectErrorCount() {
        return connectErrorCount;
    }

    public void setConnectErrorCount(long connectErrorCount) {
        this.connectErrorCount = connectErrorCount;
    }

    public long getCreateCount() {
        return createCount;
    }

    public void setCreateCount(long createCount) {
        this.createCount = createCount;
    }

    public long getCreateErrorCount() {
        return createErrorCount;
    }

    public void setCreateErrorCount(long createErrorCount) {
        this.createErrorCount = createErrorCount;
    }

    public long getDestroyCount() {
        return destroyCount;
    }

    public void setDestroyCount(long destroyCount) {
        this.destroyCount = destroyCount;
    }

    public long getDiscardCount() {
        return discardCount;
    }

    public void setDiscardCount(long discardCount) {
        this.discardCount = discardCount;
    }

    public long getDupCloseCount() {
        return dupCloseCount;
    }

    public void setDupCloseCount(long dupCloseCount) {
        this.dupCloseCount = dupCloseCount;
    }

    public long getErrorCount() {
        return errorCount;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public long getInitialSize() {
        return initialSize;
    }

    public void setInitialSize(long initialSize) {
        this.initialSize = initialSize;
    }

    public int getLockQueueLength() {
        return lockQueueLength;
    }

    public void setLockQueueLength(int lockQueueLength) {
        this.lockQueueLength = lockQueueLength;
    }

    public long getCreateTimeSpanMillis() {
        return createTimeSpanMillis;
    }

    public void setCreateTimeSpanMillis(long createTimeSpanMillis) {
        this.createTimeSpanMillis = createTimeSpanMillis;
    }

    public long getRemoveAbandonedCount() {
        return removeAbandonedCount;
    }

    public void setRemoveAbandonedCount(long removeAbandonedCount) {
        this.removeAbandonedCount = removeAbandonedCount;
    }
}
