package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;

import java.util.ArrayList;
import java.util.List;

public class MemoryInfo extends BaseEntity<MemoryInfo> {

    private long         max;
    private long         total;
    private long         free;
    private long         heapUsage;
    private long         nonHeapUsage;
    private List<GcInfo> gcs = new ArrayList<GcInfo>();

    public MemoryInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMemory(this);
    }

    public MemoryInfo addGc(GcInfo gc) {
        gcs.add(gc);
        return this;
    }

    @Override
    public void mergeAttributes(MemoryInfo other) {
        max = other.getMax();

        total = other.getTotal();

        free = other.getFree();

        heapUsage = other.getHeapUsage();

        nonHeapUsage = other.getNonHeapUsage();
    }

    public long getMax() {
        return max;
    }

    public MemoryInfo setMax(long max) {
        this.max = max;
        return this;
    }

    public long getTotal() {
        return total;
    }

    public MemoryInfo setTotal(long total) {
        this.total = total;
        return this;
    }

    public long getFree() {
        return free;
    }

    public MemoryInfo setFree(long free) {
        this.free = free;
        return this;
    }

    public long getHeapUsage() {
        return heapUsage;
    }

    public MemoryInfo setHeapUsage(long heapUsage) {
        this.heapUsage = heapUsage;
        return this;
    }

    public long getNonHeapUsage() {
        return nonHeapUsage;
    }

    public MemoryInfo setNonHeapUsage(long nonHeapUsage) {
        this.nonHeapUsage = nonHeapUsage;
        return this;
    }

    public List<GcInfo> getGcs() {
        return gcs;
    }

    public void setGcs(List<GcInfo> gcs) {
        this.gcs = gcs;
    }

}
