/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.analyzer;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.Metric;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricTagAggregator {
    private static final MetricTagAggregator instance = new MetricTagAggregator();
    private static final String OTHERS = "others";
    private static final String EMPTY = "empty";
    public static int MAX_KEY_SIZE = 1000;
    private volatile ConcurrentHashMap<String, Map<String, MetricTagItem>> metrics = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> metricThresholds = new ConcurrentHashMap();

    public static MetricTagAggregator getInstance() {
        return instance;
    }

    public void addCountMetric(String name, int quantity, Map<String, String> tags) {
        MetricTagItem metricTagItem = this.makeSureMetricExist(name, tags, this.metrics);
        this.addCountMetric(quantity, metricTagItem);
    }

    private void addCountMetric(int quantity, MetricTagItem metricTagItem) {
        metricTagItem.count.addAndGet(quantity);
    }

    public void addTimerMetric(String name, long durationInMillis, Map<String, String> tags) {
        MetricTagItem item = this.makeSureMetricExist(name, tags, this.metrics);
        this.addTimerMetric(durationInMillis, item);
    }

    private void addTimerMetric(long durationInMillis, MetricTagItem item) {
        item.count.incrementAndGet();
        item.sum.addAndGet(durationInMillis);
        if (item.slowThreshold > 0 && durationInMillis > (long)item.slowThreshold) {
            item.slowCount.incrementAndGet();
        }
    }

    private void buildMetricMessage(Long time, Map<String, Map<String, MetricTagItem>> datas) {
        Transaction transaction = Cat.newTransaction("System", this.getClass().getSimpleName());
        for (Map.Entry<String, Map<String, MetricTagItem>> entry : datas.entrySet()) {
            String key = entry.getKey();
            Map<String, MetricTagItem> items = entry.getValue();
            for (Map.Entry<String, MetricTagItem> tagItem : items.entrySet()) {
                String tagKey = tagItem.getKey();
                MetricTagItem item = tagItem.getValue();
                int count = item.getCount().get();
                long sum = item.getSum().get();
                if (EMPTY.equals(tagKey)) {
                    int slowCount = item.getSlowCount();
                    if (sum > 0L) {
                        this.logMetric(key, "S,C", String.format("%s,%s", count, sum), time);
                    } else if (count > 0) {
                        this.logMetric(key, "C", String.valueOf(count), time);
                    }
                    if (slowCount <= 0) continue;
                    this.logMetric(key + ".slowCount", "C", String.valueOf(item.getSlowCount()), time);
                    continue;
                }
                if (count <= 0) continue;
                if (sum > 0L) {
                    this.logMetric(key, "TD", String.format("%s,%s,%s", count, sum, tagKey), time);
                    continue;
                }
                this.logMetric(key, "TC", String.format("%s,%s,%s", count, count, tagKey), time);
            }
        }
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        tree.setDomain(this.getDomain());
        tree.setDiscardPrivate(false);
        transaction.setStatus("0");
        transaction.complete();
    }

    private MetricTagItem createMetricItem(String key) {
        MetricTagItem item = new MetricTagItem();
        item.setKey(key);
        Integer threshold = this.metricThresholds.get(key);
        if (threshold != null) {
            item.setSlowThreshold(threshold);
        }
        return item;
    }

    private String buildTagKey(Map<String, String> tags) {
        if (tags == null || tags.size() == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            if (!first) {
                sb.append('&');
            } else {
                first = false;
            }
            sb.append(tag.getKey()).append('=').append(tag.getValue());
        }
        return sb.toString();
    }

    public void setMetricSlowThreshold(String key, int slow) {
        this.metricThresholds.put(key, slow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, MetricTagItem>> getAndResetMetrics() {
        ConcurrentHashMap<String, Map<String, MetricTagItem>> cloned = this.metrics;
        MetricTagAggregator metricTagAggregator = this;
        synchronized (metricTagAggregator) {
            this.metrics = new ConcurrentHashMap();
            for (Map.Entry entry : cloned.entrySet()) {
                String key = (String)entry.getKey();
                Map items = (Map)entry.getValue();
                ConcurrentHashMap<String, MetricTagItem> newItem = new ConcurrentHashMap<String, MetricTagItem>();
                for (Map.Entry tagItem : items.entrySet()) {
                    if (((MetricTagItem)tagItem.getValue()).getCount().get() <= 0) continue;
                    String itemKey = (String)tagItem.getKey();
                    newItem.put(itemKey, this.createMetricItem(itemKey));
                }
                this.metrics.put(key, newItem);
            }
        }
        return cloned;
    }

    protected String getDomain() {
        return Cat.getManager().getDomain();
    }

    private void logMetric(String name, String status, String keyValuePairs, Long time) {
        try {
            Metric metric = Cat.getProducer().newMetric("", name);
            if (keyValuePairs != null && keyValuePairs.length() > 0) {
                metric.addData(keyValuePairs);
            }
            if (time != null) {
                metric.setTimestamp(time);
            }
            metric.setStatus(status);
            metric.complete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetricTagItem makeSureMetricExist(String key, Map<String, String> tags, Map<String, Map<String, MetricTagItem>> metrics) {
        String tagKey;
        MetricTagItem item;
        Map<String, MetricTagItem> items = metrics.get(key);
        if (null == items) {
            MetricTagAggregator metricTagAggregator = this;
            synchronized (metricTagAggregator) {
                items = metrics.get(key);
                if (null == items) {
                    items = new ConcurrentHashMap<String, MetricTagItem>();
                    metrics.put(key, items);
                }
            }
        }
        if (null == (item = items.get(tagKey = this.buildTagKey(tags)))) {
            if (items.size() >= MAX_KEY_SIZE) {
                Cat.logEvent("cat.TooManyTagValuesForMetric", key);
                tagKey = OTHERS;
            }
            if (null == (item = items.get(tagKey))) {
                MetricTagAggregator metricTagAggregator = this;
                synchronized (metricTagAggregator) {
                    item = items.get(tagKey);
                    if (null == item) {
                        item = this.createMetricItem(tagKey);
                        items.put(tagKey, item);
                    }
                }
            }
        }
        return item;
    }

    void sendMetricTagData() {
        Map<String, Map<String, MetricTagItem>> items = this.getAndResetMetrics();
        this.sendMetricMessage(null, items);
    }

    private void sendMetricMessage(Long time, Map<String, Map<String, MetricTagItem>> items) {
        boolean hasData = false;
        block0: for (Map<String, MetricTagItem> entry : items.values()) {
            for (Map.Entry<String, MetricTagItem> item : entry.entrySet()) {
                if (item.getValue().getCount().get() <= 0) continue;
                hasData = true;
                continue block0;
            }
        }
        if (hasData) {
            this.buildMetricMessage(time, items);
        }
    }

    public class MetricTagItem {
        private String key;
        private int slowThreshold;
        private AtomicInteger count = new AtomicInteger();
        private AtomicInteger slowCount = new AtomicInteger();
        private AtomicLong sum = new AtomicLong();

        AtomicInteger getCount() {
            return this.count;
        }

        void setCount(AtomicInteger count) {
            this.count = count;
        }

        String getKey() {
            return this.key;
        }

        void setKey(String key) {
            this.key = key;
        }

        AtomicLong getSum() {
            return this.sum;
        }

        int getSlowCount() {
            return this.slowCount.get();
        }

        int getSlowThreshold() {
            return this.slowThreshold;
        }

        void setSlowThreshold(int slowThreshold) {
            this.slowThreshold = slowThreshold;
        }
    }
}

