/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.util.StringUtils;

public class MessageId {
    private String domain;
    private String ipAddressInHex;
    private int hour;
    private int index;

    public MessageId(String domain, String ipAddressInHex, int hour, int index) {
        this.domain = domain;
        this.ipAddressInHex = ipAddressInHex;
        this.hour = hour;
        this.index = index;
    }

    public static MessageId parse(String messageId) {
        int index = -1;
        int hour = -1;
        String ipAddressInHex = null;
        String domain = null;
        int len = messageId.length();
        int part = 4;
        int end = len;
        block5: for (int i = len - 1; i >= 0; --i) {
            char ch = messageId.charAt(i);
            if (ch != '-') continue;
            switch (part) {
                case 4: {
                    index = Integer.parseInt(messageId.substring(i + 1, end));
                    end = i;
                    --part;
                    continue block5;
                }
                case 3: {
                    hour = Integer.parseInt(messageId.substring(i + 1, end));
                    end = i;
                    --part;
                    continue block5;
                }
                case 2: {
                    ipAddressInHex = messageId.substring(i + 1, end);
                    domain = messageId.substring(0, i);
                    --part;
                    continue block5;
                }
            }
        }
        if (domain == null || hour < 0 || index < 0) {
            throw new RuntimeException("Invalid message ID format: " + messageId);
        }
        return new MessageId(domain, ipAddressInHex, hour, index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageId) {
            MessageId o = (MessageId)obj;
            if (!this.domain.equals(o.domain)) {
                return false;
            }
            if (!this.ipAddressInHex.equals(o.ipAddressInHex)) {
                return false;
            }
            if (this.hour != o.hour) {
                return false;
            }
            return this.index == o.index;
        }
        return false;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getHour() {
        return this.hour;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIpAddress() {
        StringBuilder sb = new StringBuilder();
        String local = this.ipAddressInHex;
        int index = local.lastIndexOf(".");
        if (index > 0) {
            local = local.substring(0, index);
        }
        int length = local.length();
        for (int i = 0; i < length; i += 2) {
            char ch1 = local.charAt(i);
            char ch2 = local.charAt(i + 1);
            int value = 0;
            value = ch1 >= '0' && ch1 <= '9' ? (value += ch1 - 48 << 4) : (value += ch1 - 97 + 10 << 4);
            value = ch2 >= '0' && ch2 <= '9' ? (value += ch2 - 48) : (value += ch2 - 97 + 10);
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public String getIpAddressInHex() {
        return this.ipAddressInHex;
    }

    public int getIpAddressValue() {
        String local = this.ipAddressInHex;
        int length = local.length();
        if (length > 8) {
            int index = this.ipAddressInHex.lastIndexOf(".");
            if (index < 0) {
                return this.getIpHexValue(local);
            }
            local = this.ipAddressInHex.substring(0, index);
            String pidStr = this.ipAddressInHex.substring(index + 1);
            if (StringUtils.isEmpty(pidStr)) {
                return this.getIpHexValue(local);
            }
            if (pidStr.length() > 5) {
                pidStr = pidStr.substring(0, 5);
            }
            int pid = Integer.parseInt(pidStr);
            return pid << 17 ^ this.getIpHexValue(local);
        }
        return this.getIpHexValue(local);
    }

    private int getIpHexValue(String ipHex) {
        int ip = 0;
        int length = ipHex.length();
        for (int i = 0; i < length; i += 2) {
            char ch1 = ipHex.charAt(i);
            char ch2 = ipHex.charAt(i + 1);
            int value = 0;
            value = ch1 >= '0' && ch1 <= '9' ? (value += ch1 - 48 << 4) : (value += ch1 - 97 + 10 << 4);
            value = ch2 >= '0' && ch2 <= '9' ? (value += ch2 - 48) : (value += ch2 - 97 + 10);
            ip = (ip << 8) + value;
        }
        return ip;
    }

    public long getTimestamp() {
        return (long)(this.hour * 3600) * 1000L;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.ipAddressInHex == null ? 0 : this.ipAddressInHex.hashCode());
        result = 31 * result + this.hour;
        result = 31 * result + this.index;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.domain.length() + 30);
        sb.append(this.domain);
        sb.append('-');
        sb.append(this.ipAddressInHex);
        sb.append('-');
        sb.append(this.hour);
        sb.append('-');
        sb.append(this.index);
        return sb.toString();
    }
}

