/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationEnvironment {
    private static final Logger LOGGER;
    public static final String ENVIRONMENT;
    public static final String CELL;
    public static final String VERSION = "2.0.1";
    private static final String PROPERTIES_FILE = "/META-INF/app.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadAppName(String defaultDomain) {
        String appName = System.getProperty("cat.app.name");
        if (StringUtils.isNotEmpty(appName)) {
            return appName;
        }
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(PROPERTIES_FILE);
            if (in == null) {
                in = Cat.class.getResourceAsStream(PROPERTIES_FILE);
            }
            if (in != null) {
                Properties prop = new Properties();
                prop.load(in);
                appName = prop.getProperty("app.name");
                if (appName != null) {
                    String string = appName;
                    return string;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return defaultDomain;
    }

    static {
        String cell;
        String env;
        LOGGER = LoggerFactory.getLogger(ApplicationEnvironment.class);
        try {
            String file = "/data/webapps/appenv";
            Properties pro = new Properties();
            pro.load(new FileInputStream(new File(file)));
            env = pro.getProperty("env");
            if (StringUtils.isEmpty(env)) {
                env = pro.getProperty("deployenv");
            }
            cell = pro.getProperty("cell");
        }
        catch (Exception e) {
            env = "unknown";
            cell = "";
        }
        if (env == null) {
            env = "unknown";
        }
        if (cell == null) {
            cell = "";
        }
        ENVIRONMENT = env.trim();
        CELL = cell.trim();
    }
}

