/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.datasource;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatabaseParserHelper {
    private Map<String, Database> connections = new LinkedHashMap<String, Database>();

    private String find(String con, String key) {
        int index = con.indexOf(key);
        int start = 0;
        int end = 0;
        if (index > -1) {
            for (int i = index + key.length(); i < con.length(); ++i) {
                if (con.charAt(i) == '=') {
                    start = i + 1;
                }
                if (con.charAt(i) != ')') continue;
                end = i;
                break;
            }
        }
        return con.substring(start, end);
    }

    public Database parseDatabase(String connection) {
        Database database;
        block12: {
            database = this.connections.get(String.valueOf(connection));
            if (database == null && StringUtils.isNotEmpty(connection)) {
                try {
                    if (connection.contains("jdbc:mysql://")) {
                        String con = connection.split("jdbc:mysql://")[1];
                        con = con.split("\\?")[0];
                        int index = con.indexOf(":");
                        String ip = "";
                        ip = index < 0 ? con.split("/")[0] : con.substring(0, index);
                        String name = con.substring(con.indexOf("/") + 1);
                        database = new Database(name, ip);
                        this.connections.put(connection, database);
                        break block12;
                    }
                    if (connection.contains("jdbc:oracle")) {
                        if (connection.contains("DESCRIPTION")) {
                            String name = this.find(connection, "SERVICE_NAME");
                            String ip = this.find(connection, "HOST");
                            database = new Database(name, ip);
                            this.connections.put(connection, database);
                        } else if (connection.contains("@//")) {
                            String[] tabs = connection.split("/");
                            String name = tabs[tabs.length - 1];
                            String ip = tabs[tabs.length - 2];
                            int index = ip.indexOf(58);
                            if (index > -1) {
                                ip = ip.substring(0, index);
                            }
                            database = new Database(name, ip);
                            this.connections.put(connection, database);
                        } else {
                            String[] tabs = connection.split(":");
                            String ip = "Default";
                            for (String str : tabs) {
                                int index = str.indexOf("@");
                                if (index <= -1) continue;
                                ip = str.substring(index + 1).trim();
                            }
                            String name = tabs[tabs.length - 1];
                            int index = name.indexOf(47);
                            if (index > -1) {
                                name = name.substring(index + 1);
                            }
                            database = new Database(name, ip);
                            this.connections.put(connection, database);
                        }
                        break block12;
                    }
                    return new Database("default", "default");
                }
                catch (Exception e) {
                    Cat.logError(connection, e);
                }
            }
        }
        return database;
    }

    public class Database {
        private String name;
        private String ip;

        Database(String name, String ip) {
            this.name = name;
            this.ip = ip;
        }

        public String toString() {
            return this.name + '_' + this.ip;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }
}

