/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.util;

import cn.com.duiba.cat.util.Files;
import cn.com.duiba.cat.util.Urls;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkHelper.class);
    private static final int TIMEOUT = 2000;

    public static String readFromUrlWithRetry(String url) throws Exception {
        try {
            InputStream input = Urls.forIO().readTimeout(2000).connectTimeout(2000).openStream(url);
            return Files.forIO().readFrom(input, "utf-8");
        }
        catch (Exception e) {
            try {
                InputStream in = Urls.forIO().connectTimeout(2000).readTimeout(2000).openStream(url);
                return Files.forIO().readFrom(in, "utf-8");
            }
            catch (Exception retryException) {
                LOGGER.error("error when read url:" + url + ",exception is " + retryException.getMessage());
                throw retryException;
            }
        }
    }
}

