package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.client.entity.Server;

import java.util.Set;

public interface ClientConfigService {

    int getClientConnectTimeout();

    String getDomain();

    int getLongConfigThreshold(String key);

    int getLongThresholdByDuration(String key, int duration);

    String getRouters();

    double getSamplingRate();

    Set<Server> getServers();

    boolean isMessageBlock();

    MessageType parseMessageType(MessageTree tree);

    void refreshConfig();

}
