package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Property extends BaseEntity<Property> {

    private String name;
    private String text;

    public Property() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitProperty(this);
    }

    @Override
    public void mergeAttributes(Property other) {
        if (other.getName() != null) {
            name = other.getName();
        }
    }

    public String getName() {
        return name;
    }

    public Property setName(String name) {
        this.name = name;
        return this;
    }

    public String getText() {
        return text;
    }

    public Property setText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Property property = (Property) o;

        return new EqualsBuilder().append(name, property.name).append(text, property.text).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(name).append(text).toHashCode();
    }
}
