package cn.com.duiba.cat.status.model.entity;

import cn.com.duiba.cat.status.model.BaseEntity;
import cn.com.duiba.cat.status.model.IVisitor;

public class GcInfo extends BaseEntity<GcInfo> {

    private String name;
    private long   count;
    private long   time;

    public GcInfo() {
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitGc(this);
    }

    @Override
    public void mergeAttributes(GcInfo other) {
        if (other.getName() != null) {
            name = other.getName();
        }

        count = other.getCount();

        time = other.getTime();
    }

    public String getName() {
        return name;
    }

    public GcInfo setName(String name) {
        this.name = name;
        return this;
    }

    public long getCount() {
        return count;
    }

    public GcInfo setCount(long count) {
        this.count = count;
        return this;
    }

    public long getTime() {
        return time;
    }

    public GcInfo setTime(long time) {
        this.time = time;
        return this;
    }

}
