/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.analyzer;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.Event;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EventAggregator {
    private static EventAggregator instance = new EventAggregator();
    private volatile ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> events = new ConcurrentHashMap();

    public static EventAggregator getInstance() {
        return instance;
    }

    private EventData createEventData(String type, String name) {
        return new EventData(type, name);
    }

    private ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> getAndResetEvents() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> cloned = this.events;
        this.events = new ConcurrentHashMap();
        for (Map.Entry<String, ConcurrentHashMap<String, EventData>> entry : cloned.entrySet()) {
            String type = entry.getKey();
            this.events.putIfAbsent(type, new ConcurrentHashMap());
        }
        return cloned;
    }

    public String getDomain() {
        return Cat.getManager().getDomain();
    }

    public void logBatchEvent(String type, String name, int total, int fail) {
        this.makeSureEventExist(type, name).add(total, fail);
    }

    public void logEvent(Event e) {
        this.makeSureEventExist(e.getType(), e.getName()).add(e);
    }

    private EventData makeSureEventExist(String type, String name) {
        EventData data;
        ConcurrentHashMap<String, EventData> oldValue;
        ConcurrentHashMap<String, EventData> item = this.events.get(type);
        if (null == item && (oldValue = this.events.putIfAbsent(type, item = new ConcurrentHashMap())) != null) {
            item = oldValue;
        }
        if (null == (data = item.get(name))) {
            data = this.createEventData(type, name);
            EventData oldValue2 = item.putIfAbsent(name, data);
            if (oldValue2 == null) {
                return data;
            }
            return oldValue2;
        }
        return data;
    }

    void sendEventData() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, EventData>> events = this.getAndResetEvents();
        boolean hasData = false;
        block0: for (Map map : events.values()) {
            for (EventData eventData : map.values()) {
                if (eventData.getCount() <= 0) continue;
                hasData = true;
                continue block0;
            }
        }
        if (hasData) {
            Transaction t = Cat.newTransaction("System", this.getClass().getSimpleName());
            MessageTree messageTree = Cat.getManager().getThreadLocalMessageTree();
            messageTree.setDomain(this.getDomain());
            messageTree.setDiscardPrivate(false);
            for (Map map : events.values()) {
                for (EventData data : map.values()) {
                    if (data.getCount() <= 0) continue;
                    Event tmp = Cat.newEvent(data.getType(), data.getName());
                    StringBuilder sb = new StringBuilder(32);
                    sb.append('@').append(data.getCount()).append(";").append(data.getError());
                    tmp.addData(sb.toString());
                    tmp.setSuccessStatus();
                    tmp.complete();
                }
            }
            t.setSuccessStatus();
            t.complete();
        }
    }

    public class EventData {
        private String type;
        private String name;
        private AtomicInteger count = new AtomicInteger();
        private AtomicInteger error = new AtomicInteger();

        EventData(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public EventData add(Event e) {
            this.count.incrementAndGet();
            if (!e.isSuccess()) {
                this.error.incrementAndGet();
            }
            return this;
        }

        public EventData add(int count, int fail) {
            this.count.addAndGet(count);
            this.error.addAndGet(fail);
            return this;
        }

        public int getCount() {
            return this.count.get();
        }

        public int getError() {
            return this.error.get();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

