/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.message.ForkableTransaction;
import cn.com.duiba.cat.message.ForkedTransaction;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.DefaultEvent;
import cn.com.duiba.cat.message.internal.DefaultForkedTransaction;
import cn.com.duiba.cat.message.internal.DefaultTransaction;
import cn.com.duiba.cat.message.internal.MessageIdFactory;
import cn.com.duiba.cat.message.io.TcpSocketSender;
import cn.com.duiba.cat.message.spi.MessageManager;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.message.spi.internal.DefaultMessageTree;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.DefaultClientConfigService;
import cn.com.duiba.cat.model.configuration.NetworkInterfaceManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageManager
implements MessageManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageManager.class);
    private static final int SIZE = 2000;
    private static final long HOUR = 3600000L;
    private static MessageManager INSTANCE = new DefaultMessageManager();
    private long throttleTimes;
    private String domain;
    private String hostName;
    private String ip;
    private boolean firstMessage = true;
    private ClientConfigService configService = DefaultClientConfigService.getInstance();
    private TcpSocketSender sender = TcpSocketSender.getInstance();
    private MessageIdFactory factory = MessageIdFactory.getInstance();
    private AtomicInteger sampleCount = new AtomicInteger();
    private ThreadLocal<Context> context = new ThreadLocal();
    private TransactionHelper validator = new TransactionHelper();

    private DefaultMessageManager() {
        this.initialize();
    }

    public static MessageManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void add(Message message) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.add(message);
        }
    }

    @Override
    public void end(Transaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.end(this, transaction);
        }
    }

    public void flush(MessageTree tree, boolean clearContext) {
        if (this.sender != null) {
            this.sender.send(tree);
            if (clearContext) {
                this.reset();
            }
        } else {
            ++this.throttleTimes;
            if (this.throttleTimes % 10000L == 0L || this.throttleTimes == 1L) {
                LOGGER.info("Cat Message is throttled! Times:" + this.throttleTimes);
            }
        }
    }

    @Override
    public ClientConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public Context getContext() {
        Context ctx = this.context.get();
        if (ctx != null) {
            return ctx;
        }
        ctx = new Context(this.domain, this.hostName, this.ip);
        this.context.set(ctx);
        return ctx;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public String getMetricType() {
        return "";
    }

    public void setMetricType(String metricType) {
    }

    @Override
    public Transaction getPeekTransaction() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.peekTransaction();
        }
        return null;
    }

    @Override
    public MessageTree getThreadLocalMessageTree() {
        Context ctx = this.context.get();
        if (ctx == null) {
            this.setup();
        }
        ctx = this.context.get();
        return ctx.tree;
    }

    @Override
    public boolean hasContext() {
        Context context = this.context.get();
        return context != null;
    }

    private boolean hitSample(double sampleRatio) {
        int count = this.sampleCount.incrementAndGet();
        return count % (int)(1.0 / sampleRatio) == 0;
    }

    private void initialize() {
        this.domain = String.valueOf(this.configService.getDomain()).intern();
        this.hostName = NetworkInterfaceManager.INSTANCE.getLocalHostName().intern();
        this.ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress().intern();
        try {
            this.factory.initialize(this.domain);
        }
        catch (Exception e) {
            LOGGER.error("error when create mark file", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public boolean isCatEnabled() {
        return true;
    }

    @Override
    @Deprecated
    public boolean isMessageEnabled() {
        return true;
    }

    @Override
    public boolean isTraceMode() {
        Context content = this.getContext();
        if (content != null) {
            return content.isTraceMode();
        }
        return false;
    }

    @Override
    public void setTraceMode(boolean traceMode) {
        Context context = this.getContext();
        if (context != null) {
            context.setTraceMode(traceMode);
        }
    }

    private String nextMessageId() {
        return this.factory.getNextId();
    }

    public boolean notExsitCause(Throwable e) {
        Context ctx = this.context.get();
        if (ctx != null) {
            return ctx.notExsitCause(e);
        }
        return true;
    }

    @Override
    public void reset() {
        Context ctx = this.context.get();
        if (ctx != null) {
            ctx.reset();
        }
    }

    @Override
    public void setup() {
        Context ctx = new Context(this.domain, this.hostName, this.ip);
        double samplingRate = this.configService.getSamplingRate();
        if (samplingRate < 1.0 && this.hitSample(samplingRate)) {
            ctx.tree.setHitSample(true);
        }
        this.context.set(ctx);
    }

    @Override
    public void start(Transaction transaction, boolean forked) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.start(transaction, forked);
        } else if (this.firstMessage) {
            this.firstMessage = false;
            LOGGER.error("CAT client is not enabled because it's not initialized yet");
        }
    }

    class TransactionHelper {
        TransactionHelper() {
        }

        private void migrateMessage(Stack<Transaction> stack, Transaction source, Transaction target, int level) {
            Transaction current = level < stack.size() ? (Transaction)stack.get(level) : null;
            boolean shouldKeep = false;
            List<Message> childs = source.getChildren();
            for (Message child : childs) {
                if (child != current) {
                    target.addChild(child);
                    continue;
                }
                DefaultTransaction cloned = new DefaultTransaction(current.getType(), current.getName(), DefaultMessageManager.this);
                cloned.setTimestamp(current.getTimestamp());
                cloned.setDurationInMicros(current.getDurationInMicros());
                cloned.setStatus("0");
                target.addChild(cloned);
                this.migrateMessage(stack, current, cloned, level + 1);
                shouldKeep = true;
            }
            source.getChildren().clear();
            if (shouldKeep) {
                source.addChild(current);
            }
        }

        public void truncateAndFlush(Context ctx, long timestamp) {
            MessageTree tree = ctx.tree;
            List<ForkableTransaction> forkableTransactions = tree.getForkableTransactions();
            Stack stack = ctx.stack;
            Message message = tree.getMessage();
            if (message instanceof DefaultTransaction || message instanceof DefaultForkedTransaction) {
                List<ForkableTransaction> forkables;
                Object t;
                String id;
                if (forkableTransactions != null) {
                    for (ForkableTransaction forkableTransaction : forkableTransactions) {
                        forkableTransaction.complete();
                    }
                }
                if ((id = tree.getMessageId()) == null) {
                    id = DefaultMessageManager.this.nextMessageId();
                    tree.setMessageId(id);
                }
                String rootId = tree.getRootMessageId();
                String childId = DefaultMessageManager.this.nextMessageId();
                Transaction source = (Transaction)message;
                DefaultTransaction target = new DefaultTransaction(source.getType(), source.getName(), DefaultMessageManager.this);
                target.setTimestamp(source.getTimestamp());
                target.setDurationInMicros(source.getDurationInMicros());
                target.setStatus("0");
                this.migrateMessage(stack, source, target, 1);
                if (message instanceof DefaultTransaction) {
                    DefaultEvent next = new DefaultEvent("RemoteCall", "Next");
                    next.addData(childId);
                    next.setStatus("0");
                    target.addChild(next);
                } else {
                    t = (DefaultForkedTransaction)stack.get(0);
                    ArrayList<Message> temp = new ArrayList<Message>();
                    DefaultEvent parent = new DefaultEvent("RemoteCall", "Next");
                    parent.addData(id);
                    parent.setStatus("0");
                    temp.add(parent);
                    temp.addAll(((DefaultForkedTransaction)t).getChildren());
                    ((DefaultForkedTransaction)t).getChildren().clear();
                    ((DefaultForkedTransaction)t).getChildren().addAll(temp);
                }
                t = tree.copy();
                t.setMessage(target);
                ctx.tree.setMessageId(childId);
                ctx.tree.setParentMessageId(id);
                ctx.tree.setRootMessageId(rootId != null ? rootId : id);
                if (ctx.knownExceptions != null) {
                    ctx.knownExceptions.clear();
                }
                if ((forkables = ctx.tree.getForkableTransactions()) != null) {
                    forkables.clear();
                }
                ctx.length = stack.size();
                ctx.totalDurationInMicros = ctx.totalDurationInMicros + target.getDurationInMicros();
                DefaultMessageManager.this.flush((MessageTree)t, false);
            }
        }
    }

    public class Context {
        private MessageTree tree = new DefaultMessageTree();
        private Stack<Transaction> stack = new Stack();
        private int length;
        private boolean traceMode;
        private long totalDurationInMicros;
        private Set<Throwable> knownExceptions;

        public Context(String domain, String hostName, String ipAddress) {
            Thread thread = Thread.currentThread();
            String groupName = thread.getThreadGroup().getName();
            this.tree.setThreadGroupName(groupName);
            this.tree.setThreadId(String.valueOf(thread.getId()));
            this.tree.setThreadName(thread.getName());
            this.tree.setDomain(domain);
            this.tree.setHostName(hostName);
            this.tree.setIpAddress(ipAddress);
            this.length = 1;
        }

        public void add(Message message) {
            if (this.stack.isEmpty()) {
                MessageTree tree = this.tree.copy();
                tree.setMessage(message);
                DefaultMessageManager.this.flush(tree, true);
            } else {
                Transaction parent = this.stack.peek();
                this.addTransactionChild(message, parent);
            }
        }

        public void addForkableTransaction(ForkableTransaction forkableTransaction) {
            this.tree.addForkableTransaction(forkableTransaction);
        }

        private void addTransactionChild(Message message, Transaction transaction) {
            long messagePeriod;
            long treePeriod = this.tree.getMessage().getTimestamp() / 3600000L;
            if (treePeriod < (messagePeriod = (message.getTimestamp() - 10000L) / 3600000L) || this.length >= 2000) {
                DefaultMessageManager.this.validator.truncateAndFlush(this, message.getTimestamp());
            }
            transaction.addChild(message);
            ++this.length;
        }

        public void attach(ForkedTransaction forked, String rootMessageId, String parentMessageId) {
            if (this.stack.isEmpty()) {
                this.stack.push(forked);
                this.tree.setMessage(forked);
                this.tree.setRootMessageId(rootMessageId);
                this.tree.setParentMessageId(parentMessageId);
            }
        }

        public void detach(String rootMessageId, String parentMessageId) {
            if (this.stack.firstElement() instanceof ForkedTransaction) {
                ForkedTransaction forked = (ForkedTransaction)this.stack.pop();
                if (parentMessageId != null) {
                    MessageTree tree = this.tree.copy();
                    if (rootMessageId == null) {
                        rootMessageId = parentMessageId;
                    }
                    tree.setRootMessageId(rootMessageId);
                    tree.setParentMessageId(parentMessageId);
                    tree.setMessageId(forked.getMessageId());
                    tree.setMessage(forked);
                    DefaultMessageManager.this.flush(tree, true);
                } else {
                    List<ForkableTransaction> transactions;
                    this.length = 1;
                    if (this.knownExceptions != null) {
                        this.knownExceptions.clear();
                    }
                    if ((transactions = this.tree.getForkableTransactions()) != null) {
                        transactions.clear();
                    }
                }
            }
        }

        public boolean end(DefaultMessageManager manager, Transaction transaction) {
            if (!this.stack.isEmpty()) {
                Transaction current = this.stack.pop();
                if (transaction != current) {
                    while (transaction != current && !this.stack.empty()) {
                        current = this.stack.pop();
                    }
                }
                if (this.stack.isEmpty()) {
                    List<ForkableTransaction> forkableTransactions = this.tree.getForkableTransactions();
                    if (forkableTransactions != null && !forkableTransactions.isEmpty()) {
                        for (ForkableTransaction forkableTransaction : forkableTransactions) {
                            forkableTransaction.complete();
                        }
                    }
                    MessageTree tree = this.tree.copy();
                    this.tree.setMessageId(null);
                    this.tree.setMessage(null);
                    if (this.totalDurationInMicros > 0L) {
                        tree.setDiscardPrivate(false);
                    }
                    manager.flush(tree, true);
                    return true;
                }
            }
            return false;
        }

        public Set<Throwable> getKnownExceptions() {
            return this.knownExceptions;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isTraceMode() {
            return this.traceMode;
        }

        public void setTraceMode(boolean traceMode) {
            this.traceMode = traceMode;
        }

        public boolean notExsitCause(Throwable e) {
            if (this.knownExceptions == null) {
                this.knownExceptions = new HashSet<Throwable>();
            }
            if (this.knownExceptions.contains(e)) {
                return false;
            }
            this.knownExceptions.add(e);
            return true;
        }

        public Transaction peekTransaction() {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.peek();
        }

        public void reset() {
            double samplingRate;
            if (this.knownExceptions != null) {
                this.knownExceptions.clear();
            }
            this.stack.clear();
            this.tree.setDomain(DefaultMessageManager.this.domain);
            this.tree.setIpAddress(DefaultMessageManager.this.ip);
            this.tree.setHostName(DefaultMessageManager.this.hostName);
            this.tree.setMessage(null);
            this.tree.setMessageId(null);
            this.tree.setRootMessageId(null);
            this.tree.setParentMessageId(null);
            this.tree.setSessionToken(null);
            this.tree.setDiscardPrivate(true);
            this.traceMode = false;
            this.totalDurationInMicros = 0L;
            this.length = 1;
            List<ForkableTransaction> forked = this.tree.getForkableTransactions();
            if (forked != null) {
                forked.clear();
            }
            if ((samplingRate = DefaultMessageManager.this.configService.getSamplingRate()) < 1.0 && DefaultMessageManager.this.hitSample(samplingRate)) {
                this.tree.setHitSample(true);
            } else {
                this.tree.setHitSample(false);
            }
        }

        public void start(Transaction transaction, boolean forked) {
            if (!this.stack.isEmpty()) {
                if (!(transaction instanceof ForkedTransaction)) {
                    Transaction parent = this.stack.peek();
                    this.addTransactionChild(transaction, parent);
                }
            } else {
                this.tree.setMessage(transaction);
            }
            if (!forked) {
                this.stack.push(transaction);
            }
        }
    }
}

