/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.io;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.model.configuration.property.entity.Property;
import cn.com.duiba.cat.model.configuration.property.entity.PropertyConfig;
import cn.com.duiba.cat.util.json.JsonObject;
import java.text.ParseException;
import java.util.Iterator;

public class ClientMessage {
    public static final int PROTOCOL_ID = 1667331171;
    public static final int VERSION_0 = 0;
    private final int protocolId;
    private final int version;
    private final byte[] data;

    public ClientMessage(int protocolId, int version, byte[] data) {
        this.protocolId = protocolId;
        this.version = version;
        this.data = data;
    }

    public ClientMessage(int protocolId, int version, String data) {
        this.protocolId = protocolId;
        this.version = version;
        this.data = data.getBytes();
    }

    public static void main(String[] args) {
        byte[] bytes = "catc".getBytes();
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            ret <<= 8;
            ret |= bytes[i] & 0xFF;
        }
        System.out.println(ret);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public int getVersion() {
        return this.version;
    }

    public PropertyConfig toPropertyConfig() {
        JsonObject object;
        try {
            object = new JsonObject(new String(this.data));
        }
        catch (ParseException e) {
            Cat.logError(e);
            return null;
        }
        JsonObject kvs = object.getJSONObject("kvs");
        if (kvs == null) {
            return null;
        }
        PropertyConfig config = new PropertyConfig();
        Iterator<String> it = kvs.keys();
        while (it.hasNext()) {
            String key = it.next();
            String val = kvs.getString(key);
            if (val == null) continue;
            config.addProperty(new Property().setId(key).setValue(val));
        }
        return config;
    }
}

