/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.servlet;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.DefaultMessageManager;
import cn.com.duiba.cat.message.internal.DefaultTransaction;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.servlet.MonitorResponse;
import cn.com.duiba.cat.status.http.HttpStats;
import cn.com.duiba.cat.util.Joiners;
import cn.com.duiba.cat.util.UrlParser;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CatFilter
implements Filter {
    private String servers;
    private Set<String> excludeUrls;
    private Set<String> excludePrefixes;

    private void customizeStatus(Transaction t, HttpServletRequest req) {
        Object catStatus = req.getAttribute("cat-state");
        if (catStatus != null) {
            t.setStatus(catStatus.toString());
        } else {
            t.setStatus("0");
        }
    }

    private void customizeUri(Transaction t, HttpServletRequest req) {
        if (t instanceof DefaultTransaction) {
            Object catPageUri;
            Object catPageType = req.getAttribute("cat-page-type");
            if (catPageType instanceof String) {
                ((DefaultTransaction)t).setType(catPageType.toString());
            }
            if ((catPageUri = req.getAttribute("cat-page-uri")) instanceof String) {
                ((DefaultTransaction)t).setName(catPageUri.toString());
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String path = req.getRequestURI();
        boolean exclude = this.excludePath(path);
        if (exclude) {
            chain.doFilter(request, response);
            return;
        }
        this.logTransaction(chain, req, res);
    }

    private boolean excludePath(String path) {
        try {
            boolean exclude;
            boolean bl = exclude = this.excludeUrls != null && this.excludeUrls.contains(path);
            if (!exclude && this.excludePrefixes != null) {
                for (String prefix : this.excludePrefixes) {
                    if (!path.startsWith(prefix)) continue;
                    exclude = true;
                    break;
                }
            }
            return exclude;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getCatServer() {
        try {
            if (this.servers == null) {
                DefaultMessageManager manager = (DefaultMessageManager)Cat.getManager();
                Set<Server> servers = manager.getConfigService().getServers();
                this.servers = Joiners.by(',').join(servers, new Joiners.IBuilder<Server>(){

                    @Override
                    public String asString(Server server) {
                        String ip = server.getIp();
                        int httpPort = server.getHttpPort();
                        return ip + ":" + httpPort;
                    }
                });
            }
            return this.servers;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getRequestURI(HttpServletRequest req) {
        return UrlParser.format(req.getRequestURI());
    }

    public void init(FilterConfig filterConfig) {
        String exclude = filterConfig.getInitParameter("exclude");
        if (exclude != null) {
            String[] excludeUrls;
            this.excludeUrls = new HashSet<String>();
            for (String s : excludeUrls = exclude.split(";")) {
                int index = s.indexOf("*");
                if (index > 0) {
                    if (this.excludePrefixes == null) {
                        this.excludePrefixes = new HashSet<String>();
                    }
                    this.excludePrefixes.add(s.substring(0, index));
                    continue;
                }
                this.excludeUrls.add(s);
            }
        }
    }

    private void logCatMessageId(HttpServletResponse res) {
        boolean isTraceMode = Cat.getManager().isTraceMode();
        if (isTraceMode) {
            String id = Cat.getCurrentMessageId();
            res.setHeader("X-CAT-ROOT-ID", id);
            res.setHeader("X-CAT-SERVER", this.getCatServer());
        }
    }

    private void logPayload(HttpServletRequest req, boolean top, String type) {
        try {
            if (top) {
                this.logRequestClientInfo(req, type);
                this.logRequestPayload(req, type);
            } else {
                this.logRequestPayload(req, type);
            }
        }
        catch (Exception e) {
            Cat.logError(e);
        }
    }

    private void logRequestClientInfo(HttpServletRequest req, String type) {
        StringBuilder sb = new StringBuilder(1024);
        String ip = "";
        String ipForwarded = req.getHeader("x-forwarded-for");
        ip = ipForwarded == null ? req.getRemoteAddr() : ipForwarded;
        sb.append("IPS=").append(ip);
        sb.append("&VirtualIP=").append(req.getRemoteAddr());
        sb.append("&Server=").append(req.getServerName());
        sb.append("&Referer=").append(req.getHeader("referer"));
        sb.append("&Agent=").append(req.getHeader("user-agent"));
        Cat.logEvent(type, type + ".Server", "0", sb.toString());
    }

    private void logRequestPayload(HttpServletRequest req, String type) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(req.getScheme().toUpperCase()).append('/');
        sb.append(req.getMethod()).append(' ').append(req.getRequestURI());
        String qs = req.getQueryString();
        if (qs != null) {
            sb.append('?').append(qs);
        }
        Cat.logEvent(type, type + ".Method", "0", sb.toString());
    }

    private void logTraceMode(HttpServletRequest req) {
        String traceMode = "X-CAT-TRACE-MODE";
        String headMode = req.getHeader(traceMode);
        if ("true".equals(headMode)) {
            Cat.getManager().setTraceMode(true);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logTransaction(FilterChain chain, HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        String type;
        Message message = Cat.getManager().getThreadLocalMessageTree().getMessage();
        boolean top = message == null;
        MonitorResponse res = new MonitorResponse(response);
        long start = System.currentTimeMillis();
        HttpStats stats = HttpStats.currentStatsHolder();
        int status = 0;
        if (top) {
            type = "URL";
            this.logTraceMode(req);
        } else {
            type = "URL.Forward";
        }
        Transaction t = Cat.newTransaction(type, this.getRequestURI(req));
        try {
            this.logPayload(req, top, type);
            this.logCatMessageId((HttpServletResponse)res);
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            this.customizeStatus(t, req);
            this.customizeUri(t, req);
        }
        catch (ServletException e) {
            try {
                status = 500;
                t.setStatus(e);
                Cat.logError(e);
                throw e;
                catch (IOException e2) {
                    status = 500;
                    t.setStatus(e2);
                    Cat.logError(e2);
                    throw e2;
                }
                catch (Throwable e3) {
                    status = 500;
                    t.setStatus(e3);
                    Cat.logError(e3);
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                this.customizeUri(t, req);
                t.complete();
                long end = System.currentTimeMillis();
                stats.doRequestStats(end - start, status > 0 ? status : res.getCurrentStatus());
                throw throwable;
            }
        }
        t.complete();
        long end = System.currentTimeMillis();
        stats.doRequestStats(end - start, status > 0 ? status : res.getCurrentStatus());
    }
}

