/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status.system;

import cn.com.duiba.cat.status.AbstractCollector;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import java.util.Map;

public class StaticInfoCollector
extends AbstractCollector {
    private static final String CLASSPATH = "system.java.classpath";
    private String jars;

    private void buildClasspath() {
        ClassLoader loader = StaticInfoCollector.class.getClassLoader();
        StringBuilder sb = new StringBuilder();
        this.buildClasspath(loader, sb);
        if (sb.length() > 0) {
            this.jars = sb.substring(0, sb.length() - 1);
        }
    }

    private void buildClasspath(ClassLoader loader, StringBuilder sb) {
        if (loader instanceof URLClassLoader) {
            URL[] urLs;
            for (URL url : urLs = ((URLClassLoader)loader).getURLs()) {
                String jar = this.parseJar(url.toExternalForm());
                if (jar == null) continue;
                sb.append(jar).append(',');
            }
            ClassLoader parent = loader.getParent();
            this.buildClasspath(parent, sb);
        }
    }

    @Override
    public String getId() {
        return "system.static";
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.jars == null) {
            this.buildClasspath();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(CLASSPATH, this.jars);
        map.put("system.java.verision", System.getProperty("java.version"));
        map.put("system.user.name", System.getProperty("user.name"));
        map.put("java.cat.version", "2.0.1");
        return map;
    }

    private String parseJar(String path) {
        int index;
        if (path.endsWith(".jar") && (index = path.lastIndexOf(47)) > -1) {
            return path.substring(index + 1);
        }
        return null;
    }
}

