package cn.com.duiba.cat.util;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Date;

public class Formats {

    public Formats() {
    }

    public static Formats.NumberFormat forNumber() {
        return Formats.NumberFormat.INSTANCE;
    }

    public static Formats.ObjectFormat forObject() {
        return Formats.ObjectFormat.INSTANCE;
    }

    public static enum ObjectFormat {
        INSTANCE;

        private ObjectFormat() {
        }

        public String shorten(String str, int maxLength) {
            int len = str == null ? 0 : str.length();
            if (len >= maxLength && len > 3) {
                StringBuilder sb = new StringBuilder(maxLength);
                String dots = "...";
                int dotsLen = dots.length();
                int left = (maxLength - dotsLen) / 2;
                sb.append(str.substring(0, left));
                sb.append(dots);
                sb.append(str.substring(len - maxLength + left + dotsLen));
                return sb.toString();
            } else {
                return str;
            }
        }

        public String format(Object data, String pattern) {
            if (pattern != null && pattern.length() != 0 && data != null) {
                StringBuilder sb = new StringBuilder(32);
                sb.append("{0");
                if (!pattern.startsWith("number") && !pattern.startsWith("date") && !pattern.startsWith("choice")) {
                    if (data instanceof Date) {
                        sb.append(",date,").append(pattern);
                    } else if (data instanceof Number) {
                        sb.append(",number,").append(pattern);
                    }
                } else {
                    sb.append(',').append(pattern);
                }

                sb.append('}');
                MessageFormat format = new MessageFormat(sb.toString());
                return format.format(new Object[] { data });
            } else {
                return "";
            }
        }
    }

    public static enum NumberFormat {
        INSTANCE;

        private NumberFormat() {
        }

        public String percentage(double divisor, double divident, int precision) {
            if (divident == 1.0E-6D) {
                return "N/A";
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append('0');
                if (precision > 0) {
                    sb.append('.');

                    for (int i = 0; i < precision; ++i) {
                        sb.append('0');
                    }
                }

                sb.append('%');
                return (new DecimalFormat(sb.toString())).format(divisor / divident);
            }
        }

        public String format(Number data, String pattern, String suffix) {
            if (pattern != null && pattern.length() != 0 && data != null) {
                StringBuilder sb = new StringBuilder(32);
                long base = 1000L;
                if (suffix != null && suffix.length() > 0) {
                    char ch = suffix.charAt(0);
                    if (ch == 'B' || ch == 'b') {
                        base = 1024L;
                    }
                }

                sb.append("{0,number,").append(pattern);
                sb.append('}');
                double value = data.doubleValue();
                long scale1 = 1L;
                long scale2 = -1L;
                boolean flag = value > 0.0D;
                if (!flag) {
                    value = -value;
                }

                while (value >= (double) base) {
                    scale1 *= base;
                    value /= (double) base;
                }

                if (value > 0.0D && value < 1.0D && base == 1000L) {
                    while (value < 1.0D) {
                        scale2 *= base;
                        value *= (double) base;
                    }
                }

                if (scale1 != 1L) {
                    if (scale1 == base) {
                        sb.append('K');
                    } else if (scale1 == base * base) {
                        sb.append('M');
                    } else if (scale1 == base * base * base) {
                        sb.append('G');
                    } else if (scale1 == base * base * base * base) {
                        sb.append('T');
                    } else if (scale1 == base * base * base * base * base) {
                        sb.append('P');
                    }
                }

                if (scale2 != -1L) {
                    if (scale2 == -base) {
                        sb.append('m');
                    } else if (scale2 == -base * base) {
                        sb.append('u');
                    } else if (scale2 == -base * base * base) {
                        sb.append('n');
                    }
                }

                if (suffix != null) {
                    sb.append(suffix);
                }

                MessageFormat format = new MessageFormat(sb.toString());
                return format.format(new Object[] { flag ? value : -value });
            } else {
                return "";
            }
        }
    }
}
