/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.ForkableTransaction;
import cn.com.duiba.cat.message.ForkedTransaction;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.AbstractMessage;
import cn.com.duiba.cat.message.internal.DefaultEvent;
import cn.com.duiba.cat.message.internal.DefaultForkableTransaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultForkedTransaction
extends AbstractMessage
implements ForkedTransaction {
    private String rootMessageId;
    private String parentMessageId;
    private String messageId;
    private long durationInMicros;
    private List<Message> children;
    private AtomicBoolean joined = new AtomicBoolean();

    public DefaultForkedTransaction(String rootMessageId, String parentMessageId) {
        super("System", "ChildThread");
        this.rootMessageId = rootMessageId;
        this.parentMessageId = parentMessageId;
        this.durationInMicros = System.nanoTime() / 1000L;
        this.addData(Thread.currentThread().getName());
        this.setStatus("0");
    }

    @Override
    public Transaction addChild(Message message) {
        if (this.children == null) {
            this.children = new ArrayList<Message>();
        }
        this.children.add(message);
        return this;
    }

    @Override
    public void close() {
        this.complete();
    }

    @Override
    public synchronized void complete() {
        if (!this.isCompleted()) {
            long end = System.nanoTime();
            this.durationInMicros = end / 1000L - this.durationInMicros;
            super.setCompleted(true);
            List<ForkableTransaction> forkables = Cat.getManager().getThreadLocalMessageTree().getForkableTransactions();
            if (forkables != null) {
                for (ForkableTransaction forkable : forkables) {
                    forkable.complete();
                }
            }
            if (this.joined.get()) {
                this.setName("Async.Detached." + this.getName());
                Cat.getManager().getContext().detach(this.rootMessageId, this.parentMessageId);
            } else {
                this.setName("Sync.Embedded." + this.getName());
                Cat.getManager().getContext().detach(null, null);
            }
        }
    }

    @Override
    public ForkableTransaction forFork() {
        MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
        String rootMessageId = tree.getRootMessageId();
        if (tree.getMessageId() == null) {
            tree.setMessageId(Cat.createMessageId());
        }
        DefaultForkableTransaction forkable = new DefaultForkableTransaction(rootMessageId, tree.getMessageId());
        this.addChild(forkable);
        Cat.getManager().getContext().addForkableTransaction(forkable);
        return forkable;
    }

    @Override
    public List<Message> getChildren() {
        if (this.children == null) {
            return new ArrayList<Message>();
        }
        return this.children;
    }

    @Override
    public long getDurationInMicros() {
        if (super.isCompleted()) {
            return this.durationInMicros;
        }
        return -1L;
    }

    @Override
    public void setDurationInMicros(long duration) {
        this.durationInMicros = duration;
    }

    @Override
    public long getDurationInMillis() {
        if (super.isCompleted()) {
            return this.durationInMicros / 1000L;
        }
        return -1L;
    }

    @Override
    public void setDurationInMillis(long duration) {
        this.durationInMicros = duration;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    @Override
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    public long getRawDurationInMicros() {
        return this.durationInMicros;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public synchronized Message join() {
        this.joined.set(true);
        if (this.isCompleted()) {
            return this;
        }
        if (this.messageId == null) {
            String messageId = Cat.createMessageId();
            this.setMessageId(messageId);
        }
        DefaultEvent event = new DefaultEvent("RemoteCall", "RunAway");
        event.addData(this.messageId, this.getType() + ":" + this.getName());
        event.setTimestamp(this.getTimestamp());
        event.setStatus("0");
        return event;
    }

    @Override
    public void setDurationStart(long durationStart) {
        throw new UnsupportedOperationException();
    }
}

