/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.model.configuration.NetworkInterfaceManager;
import cn.com.duiba.cat.util.Splitters;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageIdFactory {
    private static final long HOUR = 3600000L;
    private static MessageIdFactory INSTANCE = new MessageIdFactory();
    private volatile long timestamp = this.getTimestamp();
    private volatile AtomicInteger index = new AtomicInteger(0);
    private String domain = "UNKNOWN";
    private String ipAddress;
    private MappedByteBuffer byteBuffer;
    private RandomAccessFile markFile;
    private int retry;
    private String idPrefix;
    private String idPrefixOfMultiMode;
    private Map<String, AtomicInteger> map = new ConcurrentHashMap<String, AtomicInteger>(100);

    private MessageIdFactory() {
    }

    public static MessageIdFactory getInstance() {
        return INSTANCE;
    }

    public void close() {
        try {
            this.saveMark();
            this.markFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File createMarkFile(String domain) {
        File mark = new File(Cat.getCatHome(), "cat-" + domain + ".mark");
        if (!mark.exists()) {
            boolean success;
            try {
                success = mark.createNewFile();
            }
            catch (Exception e) {
                success = false;
            }
            if (!success) {
                mark = this.createTempFile(domain);
            }
        } else if (!mark.canWrite()) {
            mark = this.createTempFile(domain);
        }
        return mark;
    }

    private File createTempFile(String domain) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        return new File(tmpDir, "cat-" + domain + ".mark");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextId() {
        long timestamp = this.getTimestamp();
        if (timestamp != this.timestamp) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (timestamp != this.timestamp) {
                    this.resetCounter(timestamp);
                }
            }
        }
        int index = this.index.getAndIncrement();
        StringBuilder sb = new StringBuilder(64);
        if (Cat.isMultiInstanceEnable()) {
            sb.append(this.idPrefixOfMultiMode).append(index);
        } else {
            sb.append(this.idPrefix).append(index);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextId(String domain) {
        AtomicInteger value;
        if (domain.equals(this.domain)) {
            return this.getNextId();
        }
        long timestamp = this.getTimestamp();
        if (timestamp != this.timestamp) {
            MessageIdFactory messageIdFactory = this;
            synchronized (messageIdFactory) {
                if (timestamp != this.timestamp) {
                    this.resetCounter(timestamp);
                }
            }
        }
        if ((value = this.map.get(domain)) == null) {
            Map<String, AtomicInteger> map = this.map;
            synchronized (map) {
                value = this.map.get(domain);
                if (value == null) {
                    value = new AtomicInteger(0);
                    this.map.put(domain, value);
                }
            }
        }
        int index = value.getAndIncrement();
        StringBuilder sb = new StringBuilder(this.domain.length() + 32);
        sb.append(domain).append('-').append(this.ipAddress).append('-').append(timestamp).append('-').append(index);
        return sb.toString();
    }

    private int getProcessID() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
        }
        catch (Exception e) {
            Cat.logError(e);
            return -1;
        }
    }

    protected long getTimestamp() {
        return System.currentTimeMillis() / 3600000L;
    }

    public void initialize(String domain) throws IOException {
        block8: {
            String ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
            List<String> items = Splitters.by(".").noEmptyItem().split(ip);
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bytes[i] = (byte)Integer.parseInt(items.get(i));
            }
            StringBuilder sb = new StringBuilder(bytes.length / 2);
            for (byte b : bytes) {
                sb.append(Integer.toHexString(b >> 4 & 0xF));
                sb.append(Integer.toHexString(b & 0xF));
            }
            this.domain = domain;
            this.ipAddress = sb.toString();
            File mark = this.createMarkFile(domain);
            this.markFile = new RandomAccessFile(mark, "rw");
            this.byteBuffer = this.markFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
            this.idPrefix = this.initIdPrefix(this.getTimestamp(), false);
            this.idPrefixOfMultiMode = this.initIdPrefix(this.getTimestamp(), true);
            if (this.byteBuffer.limit() > 0) {
                try {
                    long lastTimestamp = this.byteBuffer.getLong();
                    int index = this.byteBuffer.getInt();
                    if (lastTimestamp == this.timestamp) {
                        this.index = new AtomicInteger(index + 1000);
                        int mapLength = this.byteBuffer.getInt();
                        for (int i = 0; i < mapLength; ++i) {
                            int domainLength = this.byteBuffer.getInt();
                            byte[] domainArray = new byte[domainLength];
                            this.byteBuffer.get(domainArray);
                            int value = this.byteBuffer.getInt();
                            this.map.put(new String(domainArray), new AtomicInteger(value + 1000));
                        }
                    } else {
                        this.index = new AtomicInteger(0);
                    }
                }
                catch (Exception e) {
                    ++this.retry;
                    if (this.retry != 1) break block8;
                    mark.delete();
                    this.initialize(domain);
                }
            }
        }
        this.saveMark();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MessageIdFactory.this.close();
            }
        });
    }

    private String initIdPrefix(long timestamp, boolean multiMode) {
        StringBuilder sb = new StringBuilder(this.domain.length() + 32);
        int processID = this.getProcessID();
        if (multiMode && processID > 0) {
            sb.append(this.domain).append('-').append(this.ipAddress).append(".").append(processID).append('-').append(timestamp).append('-');
        } else {
            sb.append(this.domain).append('-').append(this.ipAddress).append('-').append(timestamp).append('-');
        }
        return sb.toString();
    }

    private void resetCounter(long timestamp) {
        this.index.set(0);
        for (Map.Entry<String, AtomicInteger> entry : this.map.entrySet()) {
            entry.getValue().set(0);
        }
        this.idPrefix = this.initIdPrefix(timestamp, false);
        this.idPrefixOfMultiMode = this.initIdPrefix(timestamp, true);
        this.timestamp = timestamp;
    }

    public synchronized void saveMark() {
        try {
            this.byteBuffer.rewind();
            this.byteBuffer.putLong(this.timestamp);
            this.byteBuffer.putInt(this.index.get());
            this.byteBuffer.putInt(this.map.size());
            for (Map.Entry<String, AtomicInteger> entry : this.map.entrySet()) {
                byte[] bytes = entry.getKey().toString().getBytes();
                this.byteBuffer.putInt(bytes.length);
                this.byteBuffer.put(bytes);
                this.byteBuffer.putInt(entry.getValue().get());
            }
            this.byteBuffer.force();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }
}

