/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.model.configuration;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum NetworkInterfaceManager {
    INSTANCE;

    public static final String LOOPBACK = "127.0.0.1";
    private InetAddress local;
    private String ip;
    private String hostName;

    private NetworkInterfaceManager() {
        String hostname;
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.load();
        this.ip = this.local.getHostAddress().intern();
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = this.local.getHostName();
        }
        if (hostname == null) {
            hostname = "unknown";
        } else if (hostname.contains(".sankuai.com") || hostname.contains(".office.mos")) {
            hostname = hostname.substring(0, hostname.indexOf("."));
        }
        this.hostName = hostname;
    }

    public InetAddress findValidateIp(List<InetAddress> addresses) {
        InetAddress local = null;
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            if (address.isLoopbackAddress() || address.isSiteLocalAddress()) {
                if (local == null) {
                    local = address;
                    continue;
                }
                if (address.isSiteLocalAddress() && !address.isLoopbackAddress()) {
                    local = address;
                    continue;
                }
                if (!local.isSiteLocalAddress() || !address.isSiteLocalAddress() || !local.getHostName().equals(local.getHostAddress()) || address.getHostName().equals(address.getHostAddress())) continue;
                local = address;
                continue;
            }
            if (local != null && !local.isLoopbackAddress()) continue;
            local = address;
        }
        return local;
    }

    public String getLocalHostAddress() {
        return this.ip;
    }

    public String getLocalHostName() {
        return this.hostName;
    }

    private String getProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    private void load() {
        String ip = this.getProperty("host.ip");
        if (ip != null) {
            try {
                this.local = InetAddress.getByName(ip);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            InetAddress local = null;
            try {
                for (NetworkInterface ni : nis) {
                    if (!ni.isUp()) continue;
                    addresses.addAll(Collections.list(ni.getInetAddresses()));
                }
                local = this.findValidateIp(addresses);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.local = local;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

