/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.status;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.Heartbeat;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.DefaultMessageProducer;
import cn.com.duiba.cat.message.internal.DefaultTransaction;
import cn.com.duiba.cat.message.io.ChannelManager;
import cn.com.duiba.cat.model.configuration.ApplicationEnvironment;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.DefaultClientConfigService;
import cn.com.duiba.cat.model.configuration.NetworkInterfaceManager;
import cn.com.duiba.cat.status.StatusExtension;
import cn.com.duiba.cat.status.StatusExtensionRegister;
import cn.com.duiba.cat.status.datasource.c3p0.C3P0InfoCollector;
import cn.com.duiba.cat.status.datasource.druid.DruidInfoCollector;
import cn.com.duiba.cat.status.http.HttpStatsCollector;
import cn.com.duiba.cat.status.jvm.ClassLoadingInfoCollector;
import cn.com.duiba.cat.status.jvm.JvmInfoCollector;
import cn.com.duiba.cat.status.jvm.ThreadInfoCollector;
import cn.com.duiba.cat.status.jvm.ThreadInfoWriter;
import cn.com.duiba.cat.status.model.entity.CustomInfo;
import cn.com.duiba.cat.status.model.entity.Extension;
import cn.com.duiba.cat.status.model.entity.StatusInfo;
import cn.com.duiba.cat.status.system.ProcessorInfoCollector;
import cn.com.duiba.cat.status.system.StaticInfoCollector;
import cn.com.duiba.cat.util.Threads;
import io.netty.channel.ChannelFuture;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUpdateTask
implements Threads.Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusUpdateTask.class);
    private ClientConfigService configService = DefaultClientConfigService.getInstance();
    private ChannelManager channelManager = ChannelManager.getInstance();
    private boolean active = true;

    public StatusUpdateTask() {
        this.initialize();
    }

    private void await() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildExtenstion(StatusInfo status) {
        StatusExtensionRegister res = StatusExtensionRegister.getInstance();
        List<StatusExtension> extensions = res.getStatusExtension();
        for (StatusExtension extension : extensions) {
            Transaction t = Cat.newTransaction("System", "StatusExtension-" + extension.getId());
            try {
                Map<String, String> properties = extension.getProperties();
                if (properties.size() > 0) {
                    String id = extension.getId();
                    String des = extension.getDescription();
                    Extension item = status.findOrCreateExtension(id).setDescription(des);
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        try {
                            double doubleValue = Double.parseDouble(value);
                            if (value.equalsIgnoreCase("NaN")) {
                                doubleValue = 0.0;
                            }
                            item.findOrCreateExtensionDetail(key).setValue(doubleValue);
                        }
                        catch (Exception e) {
                            status.getCustomInfos().put(key, new CustomInfo().setKey(key).setValue(value));
                        }
                    }
                }
                t.setSuccessStatus();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                t.setStatus(e);
            }
            finally {
                t.complete();
            }
        }
        ChannelFuture future = this.channelManager.channel();
        if (null != future) {
            String localAddress = future.channel().localAddress().toString();
            status.getCustomInfos().put("localAddress", new CustomInfo().setKey("localAddress").setValue(localAddress));
            status.getCustomInfos().put("env", new CustomInfo().setKey("env").setValue(ApplicationEnvironment.ENVIRONMENT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHeartbeat(String localHostAddress) {
        Transaction t = Cat.newTransaction("System", "Status");
        Heartbeat h = Cat.getProducer().newHeartbeat("Heartbeat", localHostAddress);
        StatusInfo status = new StatusInfo();
        Cat.getManager().getThreadLocalMessageTree().setDiscardPrivate(false);
        try {
            this.buildExtenstion(status);
            h.addData(status.toString());
            h.setStatus("0");
        }
        catch (Throwable e) {
            h.setStatus(e);
            Cat.logError(e);
        }
        finally {
            h.complete();
        }
        String eventName = this.calMinuteString();
        if (Cat.isJstackEnabled()) {
            Cat.logEvent("Heartbeat", "jstack." + eventName, "0", this.buildJstack());
        }
        t.setStatus("0");
        t.complete();
    }

    private String buildJstack() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        bean.setThreadContentionMonitoringEnabled(true);
        ThreadInfo[] threads = bean.dumpAllThreads(false, false);
        return new ThreadInfoWriter().buildThreadsInfo(threads);
    }

    private String calMinuteString() {
        Calendar cal = Calendar.getInstance();
        int minute = cal.get(12);
        String eventName = minute < 10 ? "jstack-0" + minute : "jstack-" + minute;
        return eventName;
    }

    private void clearCache() {
        DefaultTransaction.clearCache();
        DefaultMessageProducer.clearCache();
    }

    @Override
    public String getName() {
        return "heartbeat-task";
    }

    private void initialize() {
        try {
            JvmInfoCollector.getInstance().registerJVMCollector();
            StatusExtensionRegister instance = StatusExtensionRegister.getInstance();
            instance.register(new StaticInfoCollector());
            instance.register(new ClassLoadingInfoCollector());
            instance.register(new ThreadInfoCollector());
            if (!this.isDocker()) {
                instance.register(new ProcessorInfoCollector());
            }
            if (Cat.isDataSourceMonitorEnabled()) {
                instance.register(new C3P0InfoCollector());
                instance.register(new DruidInfoCollector());
            }
            instance.register(new HttpStatsCollector());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logMemoryBean();
    }

    private boolean isDocker() {
        File file = new File("/data/webapps/hulk");
        String hostname = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        return hostname.startsWith("set-") || file.exists();
    }

    private void logMemoryBean() {
        try {
            for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
                LOGGER.info("memory pool:" + memoryPool.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refreshClientConfig() {
        try {
            this.configService.refreshConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        this.await();
        String localHostAddress = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
        Cat.logEvent("Reboot", localHostAddress, "0", null);
        while (this.active) {
            this.buildHeartbeat(localHostAddress);
            this.refreshClientConfig();
            this.clearCache();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            break;
        }
    }

    @Override
    public void shutdown() {
        this.active = false;
    }
}

