package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.SpDto;

import java.util.List;


/**
 * "道具"远程服务
 * 注：仅供积分商城调用
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@AdvancedFeignClient
public interface RemoteSpBackendService {
    /**
     * 通过原型id查询道具列表
     *
     * @param prototypeId 原型id
     * @return {@link List}<{@link SpDto}>
     * @throws BizException 业务异常
     */
    List<SpDto> listByPrototypeId(Long prototypeId) throws BizException;
}
