package cn.com.duiba.galaxy.api.model.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 模板DTO
 *
 * @author fangxiaorun
 * @date 2022/09/30
 */
@Getter
@Setter
public class TemplateDto implements Serializable {

    private static final long serialVersionUID = -3347026177045293683L;
    /**
     * 模板id
     */
    private Long id;

    /**
     * 模版名称
     */
    private String templateName;

    /**
     * 模版海报
     */
    private String templatePoster;

    /**
     * 模版类型
     */
    private Integer templateType;

    /**
     * 关联原型ID
     */
    private Long prototypeId;

    /**
     * 关联原型名称
     */
    private String prototypeName;

    /**
     * 模板同步类型：1全量同步，2局部推送
     */
    private Integer syncType;

    /**
     * 同步的目标APP集合
     */
    private List<Integer> syncApp;

    /**
     * 配置文档
     */
    private String configDoc;

    /**
     * 素材详情
     */
    private String materialDetail;

    /**
     * 关联数据看板
     */
    private Long dataBoard;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}




