package cn.com.duiba.galaxy.api.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 发布历史状态枚举
 *
 * @author zhangdaqing
 * @Date 2022/12/6 14:39
 * @desc
 **/
@Getter
public enum PublishHistoryStateEnum {

    INIT(0, "初始化"),
    IN_AUDIT(1, "审批中"),
    PASS(2, "审批通过"),
    REFUSE(3, "审批拒绝"),
    CANCEL(4, "取消"),
    ;

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;

    PublishHistoryStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
