package cn.com.duiba.galaxy.api.model.param.jsonfield;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 数据中保存的排行榜组件活动级别配置的json
 * @author jiaxz
 * @since 2023-01-16
 */
@Getter
@Setter
public class RankOpTimeParam implements Serializable {

    /**
     * 开始时间
     */
    @NotBlank
    private Date validStartTime;

    /**
     * 排行榜结束时间
     * @Not
     */
    @NotBlank
    private Date validEndTime;

    /**
     * 1-自然日 2-自然周 3-自然月 4-自定义
     */
    @NotBlank
    private Integer resetType;

    /**
     * 单个周期内间隔天数
     */
    private Integer resetInterval;

    /**
     * 循环期数
     */
    private Integer resetCycle;

    /**
     * 开奖时间间隔，周期结束后的第几天
     */
    private Integer opInterval;

    /**
     * 开奖时间:排行榜结束后的第n个小时
     */
    private String opTime;



}
