package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.ProjectData.PageList;
import cn.com.duiba.galaxy.api.model.dto.ProjectData.ProjectQueryTableDto;
import cn.com.duiba.galaxy.api.model.dto.ProjectData.ProjectQueryTableParam;

import java.util.List;

/**
 * 数据服务
 */
@AdvancedFeignClient
public interface RemoteDataService {

    /**
     * 分页查询queryTable数据
     * @param projectId
     * @param groupId
     * @param queryTableParam
     * @param pageNum
     * @param pageSize
     * @return
     * @throws BizException
     */
    PageList<ProjectQueryTableDto> pageQueryProjectQueryTableData(Long projectId, String groupId, ProjectQueryTableParam queryTableParam,long pageNum, long pageSize);


    /**
     * 批量更新queryTable数据
     * @param ids 更新的列表
     * @param values 更新的值
     * @return
     */
    void batchUpdate(Long projectId, List<Long> ids,ProjectQueryTableParam values);

    PageList<ProjectQueryTableDto> pageQueryProjectQueryTableDataByLastId(Long projectId, String groupId, long lastId,long pageSize) ;



}
