package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.RemoteProjectXItemDto;
import cn.com.duiba.galaxy.api.model.param.RemoteItemListParam;

import java.util.List;

/**
 * 奖品服务
 *
 * @author 刘佳辉
 * @since 2022/11/18
 */
@AdvancedFeignClient
public interface RemotePrizeService {


    /**
     * 更新奖品状态
     * @param extra
     * @param orderNo
     * @param status
     */
    void updatePrizeStatus(String extra,String orderNo, Integer status);

    /**
     * 查询奖品
     */
    List<RemoteProjectXItemDto> itemList(RemoteItemListParam itemListParam);


    /**
     * 奖品补发
     * @param workflowId
     */
    void prizeReissue(Long workflowId);

}
