package cn.com.duiba.galaxy.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.galaxy.api.model.dto.ExcelAnswerContentDto;
import cn.com.duiba.galaxy.api.model.dto.ExcelContentDto;
import cn.com.duiba.galaxy.api.model.dto.ProjectDto;
import cn.com.duiba.galaxy.api.model.param.ProjectNewOrUpdateParam;

import java.util.List;


/**
 * "项目"远程服务
 * 注：仅供积分商城调用
 *
 * @author fangxiaorun
 * @date 2022/10/11
 */
@AdvancedFeignClient
public interface RemoteProjectBackendService {

    /**
     * 创建"模版活动"
     *
     * @param param 参数
     * @return {@link Long}
     * @throws BizException 业务异常
     */
    Long createForMall(ProjectNewOrUpdateParam param) throws BizException;

    /**
     * 更新"模版活动"
     *
     * @param param 参数
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateForMall(ProjectNewOrUpdateParam param) throws BizException;

    /**
     * 通过id获取项目
     *
     * @param id id
     * @return {@link ProjectDto}
     */
    ProjectDto getById(Long id) throws BizException;


    /**
     * 通过id批量获取简单项目信息（为填充相应原型信息）
     *
     * @param ids id list
     * @return {@link List}<{@link ProjectDto}>
     * @throws BizException 业务异常
     */
    List<ProjectDto> listSimpleProjectByIds(List<Long> ids) throws BizException;

    /**
     * 更新状态
     * <p>
     * INIT(0, "待编辑"),
     * WAIT_PUBLISH(1, "待发布"),
     * WAIT_ON_LINE(2, "已发布待上线"),
     * ON_LINE(3, "已上线"),
     * OFF_LINE(4, "已下线"),
     *
     * @param projectId 项目id
     * @param state     状态
     * @return {@link Boolean}
     * @throws BizException 业务异常
     */
    Boolean updateState(Long projectId, Integer state) throws BizException;

    /**
     * 获取准备复制项目
     *
     * @param projectId 项目id
     * @return {@link ProjectDto}
     */
    ProjectDto getReadyCopyProject(Long projectId);


    /**
     * 解析excel
     * @param base64File
     * @return
     */
    ExcelContentDto parseListExcel(String base64File) throws BizException;


    /**
     * 解析答题excel
     * @param base64File
     * @return
     */
    List<ExcelAnswerContentDto> parseAnswerListExcel(String base64File, Integer answerMode) throws BizException;

}
