package cn.com.duiba.galaxy.sdk.api.user;

import cn.com.duiba.galaxy.sdk.api.base.AutowiredApi;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerData;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerExtra;
import cn.com.duiba.galaxy.common.exception.BizRuntimeException;

import java.util.List;

/**
 * [积分商城]用户api
 *
 * @author fangxiaorun
 * @date 2023/01/11
 */
public interface ConsumerApi extends AutowiredApi {
    /**
     * 批量获取用户extra信息
     *
     * @param consumerIdList 用户idList
     * @return {@link List}<{@link ConsumerExtra}>
     */
    List<ConsumerExtra> listConsumerExtraByConsumerIds(List<Long> consumerIdList);

    /**
     * 批量获取用户信息
     *
     * @param consumerIdList 用户idList
     * @return {@link List}<{@link ConsumerData}>
     * @throws cn.com.duiba.galaxy.common.exception.BizRuntimeException 业务运行时异常
     */
    List<ConsumerData> listConsumerByConsumerIds(List<Long> consumerIdList);

    /**
     * 通过用户id查询用户信息
     *
     * @param consumerId 用户id
     * @return {@link ConsumerData}
     * @throws cn.com.duiba.galaxy.common.exception.BizRuntimeException 业务运行时异常
     */
    ConsumerData getConsumerByConsumerId(Long consumerId);

    /**
     * 是否为新用户
     * true 新用户  false 老用户
     *
     * @param consumerId 用户id
     * @return boolean
     * @throws BizRuntimeException 业务运行时异常
     */
    boolean isNewUser(Long consumerId);

    /**
     * 通过开发者用户id获取用户信息
     *
     * @param appId         应用id
     * @param partnerUserId uid
     * @return {@link ConsumerData}
     */
    ConsumerData findByAppAndPartnerUserId(Long appId, String partnerUserId);

    /**
     * 通过开发者用户id获取用户信息
     *
     * @param appId          应用id
     * @param partnerUserIds uid
     * @return {@link List}<{@link ConsumerData}>
     */
    List<ConsumerData> findByAppAndPartnerUserIds(Long appId, List<String> partnerUserIds);

    /**
     * 通过key 查询consumerExtra表json里的扩展字段
     *
     * @param consumerId 用户id
     * @param key        键
     * @return {@link String}
     */
    String findConsumerExtra(Long consumerId, String key);
}
