package cn.com.duiba.galaxy.sdk.component.bindphone;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.utils.Conditions;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.EnableRiskControl;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.bindphone.param.BindPhoneParam;
import cn.com.duiba.galaxy.sdk.component.bindphone.param.SendSmsCodeParam;
import cn.com.duiba.galaxy.sdk.component.bindphone.vo.BindPhoneResult;
import cn.com.duiba.galaxy.sdk.component.bindphone.vo.SendSmsCodeResult;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import cn.com.duiba.galaxy.sdk.util.UserLock;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by hong
 * time 2023/2/11.
 */
@Slf4j
public class BindPhoneComponentDefault extends BindPhoneComponent{
    private final String componentId;

    public BindPhoneComponentDefault(String componentId) {
        this.componentId = componentId;
    }
    @Override
    @EnableRiskControl
    @CustomRequestAction(id = "sendSmsCode", desc = "绑定手机号组件-发送验证码")
    public SendSmsCodeResult sendSmsCode( UserRequestApi context, BindPhoneApi api) {
        String phoneNumber = context.getHttpRequest().getParameter("phoneNumber");
        Conditions.expectFalse(StringUtils.isBlank(phoneNumber), UnclassifiedStatusEnum.PARAM_ERROR.setDesc("请输入正确的手机号") );
        String groupName = context.getHttpRequest().getParameter("groupName");
        String slideValidate = context.getHttpRequest().getParameter("slideValidate");
        String expireTime = context.getHttpRequest().getParameter("expireTime");
        api.checkToken(context);
        UserLock lock = api.getUserLock(context, 3);
        SendSmsCodeParam param=new SendSmsCodeParam();
        try {
            param.setPlaywayId(componentId);
            param.setGroupName(groupName);
            param.setPhoneNumber(phoneNumber);
            param.setCodeLength(6);
            param.setValidate(slideValidate);
            param.setSlideValidate(slideValidate);
            if (StringUtils.isNotBlank(expireTime) && NumberUtils.isNumeric(expireTime) && Integer.parseInt(expireTime) > 0 &&  Integer.parseInt(expireTime) < 30) {
                param.setExpireTime(Integer.parseInt(expireTime));
            }

            return BeanUtils.copy(api.sendSmsCode(param), SendSmsCodeResult.class);
         }catch (BizRuntimeException e) {
            log.warn("组件LOGGER 手机号绑定组件 绑定手机号Action异常-projectId={}, playwayId={}, actionId={} userId={}, param={}"
                    , api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString(param), e);
            throw new BizRuntimeException(e.getMessage(),e.getCode(), false);
        }  catch (Exception e) {
            log.warn("组件LOGGER 手机号绑定组件 发验证码Action异常-projectId={}, playwayId={}, actionId={} userId={}, param={}"
                    , api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString(param), e);
            throw new BizRuntimeException(UnclassifiedStatusEnum.SYSTEM_ERROR.setDesc("网络异常，请稍后再试"), false);
        } finally {
            lock.unlock();
        }
    }

    @Override
    @EnableRiskControl
    @CustomRequestAction(id = "bindPhone", desc = "绑定手机号组件-绑定手机号")
    public BindPhoneResult bindPhone( UserRequestApi context, BindPhoneApi api) {
        String phoneNumber = context.getHttpRequest().getParameter("phoneNumber");
        Conditions.expectFalse(StringUtils.isBlank(phoneNumber), UnclassifiedStatusEnum.PARAM_ERROR.setDesc("请输入正确的手机号"));
        String smsCode = context.getHttpRequest().getParameter("smsCode");
        Conditions.expectFalse(StringUtils.isBlank(smsCode), UnclassifiedStatusEnum.PARAM_ERROR.setDesc("请输入正确的短信验证码"));
        String groupName = context.getHttpRequest().getParameter("groupName");
        String recordExtra = context.getHttpRequest().getParameter("recordExtra");
        api.checkToken(context);
        UserLock lock = api.getUserLock(context, 3);
        BindPhoneParam param=new BindPhoneParam();
        try {
            param.setPlaywayId(api.getActionContext().getPlaywayId());
            param.setGroupName(groupName);
            param.setPhoneNumber(phoneNumber);
            param.setSmsCode(smsCode);
            param.setRecordExtra(recordExtra);

            boolean bo = api.bindPhone(param);
            BindPhoneResult result = new BindPhoneResult();
            result.setBindResult(bo);
            return result;
        }catch (BizRuntimeException e) {
            log.warn("组件LOGGER 手机号绑定组件 绑定手机号Action异常-projectId={}, playwayId={}, actionId={} userId={}, param={}"
                    , api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString(param), e);
            throw new BizRuntimeException(e.getMessage(),e.getCode(), false);
        } catch (Exception e) {
            log.warn("组件LOGGER 手机号绑定组件 绑定手机号Action异常-projectId={}, playwayId={}, actionId={} userId={}, param={}"
                    , api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString(param), e);
            throw new BizRuntimeException(UnclassifiedStatusEnum.SYSTEM_ERROR.setDesc("网络异常，请稍后再试"), false);
        } finally {
            lock.unlock();
        }
    }

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.BINDPHONE;
    }
}
