package cn.com.duiba.galaxy.sdk.component.checkin.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
@EqualsAndHashCode(callSuper = true)
@Data
public class CheckinQueryResult extends OptionResult {
    /**
     * 当前时间戳
     */
    private Long timestamp = System.currentTimeMillis();

    /**
     * 组件开始时间
     */
    private Long startTimestamp;

    /**
     * 组件结束时间
     */
    private Long endTimestamp;

    /**
     * 今天是否签到
     */
    private Boolean todaySign;

    /**
     * 连续/累计签到天数
     */
    private Integer signDay;

    /**
     * 当前周期开始时间
     */
    private Long startTime;

    /**
     * 当前周期结束时间
     */
    private Long endTime;

    /**
     * 今天是否发奖
     */
    private Boolean todayAwardPrize;

    /**
     * 扩展值
     */
    private String extra;

    /**
     * 签到详细
     */
    private List<String> signDays;

    /**
     * 发奖模式
     *   1-超过天数不发奖
     *   2-超过天数奖励循环
     *   3-超过天数按最高天数奖励
     */
    private Integer optionRuleType;

    /**
     * 统计周期
     * 0-无
     * 2-自然周
     * 3-自然月
     * 5-自定义
     */
    private Integer intervalType;

    /**
     * 自定义 周期天数
     */
    private Integer intervalDays;
    /**
     * 统计规则 1-连续 2-累计
     */
    private Integer statType;

    /**
     * 是否是当前期次
     */
    private Boolean nowIssue;

}
