package cn.com.duiba.galaxy.sdk.component.drawprize.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;


/**
 * 其他参与类型枚举
 *
 * @author fangxiaorun
 * @date 2023/02/03
 */
@Getter
@AllArgsConstructor
public enum OtherJoinTypeEnum {
    /**
     * 无
     */
    NONE(1, "无"),
    /**
     * 积分
     */
    CREDITS(2, "积分"),
    /**
     * 道具
     */
    SP(3, "道具");

    /**
     * 类型编码
     */
    private final Integer code;

    /**
     * 类型描述
     */
    private final String desc;


    /**
     * 根据code获取枚举
     *
     * @param code 编码
     * @return {@link OtherJoinTypeEnum}
     */
    public static OtherJoinTypeEnum valueOfCode(Integer code) {
        return Arrays.stream(OtherJoinTypeEnum.values()).filter(obj -> Objects.equals(obj.code, code)).findFirst().orElse(null);
    }
}
